/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import dev.architectury.hooks.fluid.FluidStackHooks;
import java.text.NumberFormat;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.ITankHolder;

public class SCTank
extends FluidTank {
    public static final ResourceLocation BLOCK_ATLAS = ResourceLocation.withDefaultNamespace((String)"textures/atlas/blocks.png");
    private final ITankHolder owner;
    private final int tankid;

    public SCTank(ITankHolder owner, int tankSize, int tankid) {
        super(tankSize);
        this.owner = owner;
        this.tankid = tankid;
    }

    public SCTank copy() {
        SCTank tank = new SCTank(this.owner, this.capacity, this.tankid);
        if (!this.getFluid().isEmpty()) {
            tank.setFluid(this.getFluid().copy());
        }
        return tank;
    }

    public void containerTransfer() {
        this.containerTransfer(FluidStack.EMPTY);
    }

    public void containerTransfer(FluidStack restrictFluid) {
        ItemStack itemStack = this.owner.getInputContainer(this.tankid);
        if (itemStack.isEmpty()) {
            return;
        }
        FluidUtil.getFluidHandler((ItemStack)itemStack).ifPresent(itemHandler -> {
            FluidStack fluidStack = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (!fluidStack.isEmpty()) {
                if (!restrictFluid.isEmpty() && !restrictFluid.is(fluidStack.getFluid())) {
                    return;
                }
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)false);
                if (result.isSuccess()) {
                    IFluidHandlerItem handler;
                    ItemStack container = result.getResult();
                    Optional opt = FluidUtil.getFluidHandler((ItemStack)container);
                    if (opt.isPresent() && !(fluidStack = (handler = (IFluidHandlerItem)opt.orElseThrow(RuntimeException::new)).drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && fluidStack.getAmount() == 1000) {
                        FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        this.owner.setInputContainer(this.tankid, container);
                        return;
                    }
                    if (!container.isEmpty()) {
                        this.owner.addToOutputContainer(this.tankid, container);
                    }
                    if (container.getCount() == 0) {
                        FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            this.owner.setInputContainer(this.tankid, ItemStack.EMPTY);
                        }
                    }
                }
            } else {
                ItemStack container;
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)this, (int)Integer.MAX_VALUE, null, (boolean)false);
                if (result.isSuccess() && !(container = result.getResult()).isEmpty()) {
                    this.owner.addToOutputContainer(this.tankid, container);
                    if (container.getCount() == 0) {
                        FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)this, (int)1000, null, (boolean)true);
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            this.owner.setInputContainer(this.tankid, ItemStack.EMPTY);
                        }
                    }
                }
            }
        });
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty() || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid.getFluid(), drained);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.fluid.shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    public String getMouseOver() {
        String name = Localization.MODULES.TANKS.EMPTY.translate(new String[0]);
        int amount = 0;
        if (!this.fluid.isEmpty()) {
            name = this.fluid.getHoverName().getString();
            amount = this.fluid.getAmount();
        }
        NumberFormat format = NumberFormat.getInstance();
        return name + ": " + format.format(amount) + " / " + format.format(this.capacity);
    }

    protected void onContentsChanged() {
        this.owner.onFluidUpdated(this.tankid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFluid(GuiGraphics guiGraphics, AbstractContainerScreen<?> gui, int startX, int startY) {
        if (this.fluid.isEmpty()) {
            return;
        }
        int fluidLevel = (int)(48.0f * ((float)this.fluid.getAmount() / (float)this.capacity));
        TextureAtlasSprite icon = FluidStackHooks.getStillTexture((Fluid)this.fluid.getFluid());
        if (icon == null) {
            return;
        }
        int fluidColor = FluidStackHooks.getColor((Fluid)this.fluid.getFluid());
        for (int y = 0; y < 3; ++y) {
            int pixels = fluidLevel - (2 - y) * 16;
            if (pixels <= 0) continue;
            if (pixels > 16) {
                pixels = 16;
            }
            for (int x = 0; x < 2; ++x) {
                this.owner.drawImage(guiGraphics, this.tankid, gui, icon, startX + 2 + 16 * x, startY + 1 + 16 * y + (16 - pixels), 16, pixels, fluidColor);
            }
        }
    }
}

