/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.init;

import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.bus.api.IEventBus;
import org.apache.commons.lang3.ArrayUtils;

public class ModSerializers {
    public static void init(IEventBus bus) {
    }

    public static class ShortArray {
        private final short[] storage;

        public ShortArray(short[] storage) {
            this.storage = storage;
        }

        public ShortArray(Short[] storage) {
            this.storage = ArrayUtils.toPrimitive((Short[])storage);
        }

        public ShortArray(int size) {
            this.storage = new short[size];
        }

        public short get(int index) {
            return this.storage[index];
        }

        public ShortArray set(int index, short value) {
            this.storage[index] = value;
            return this;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeVarInt(this.storage.length);
            for (short s : this.storage) {
                buf.writeShort((int)s);
            }
        }

        public static ShortArray read(FriendlyByteBuf buf) {
            short[] shorts = new short[buf.readVarInt()];
            for (int i = 0; i < shorts.length; ++i) {
                shorts[i] = buf.readShort();
            }
            return new ShortArray(shorts);
        }

        public short[] getArray() {
            return this.storage;
        }
    }

    public static class BoolArray {
        private final byte[] storage;

        BoolArray(byte[] storage) {
            this.storage = storage;
        }

        public BoolArray(int size) {
            this.storage = new byte[(int)Math.ceil((double)size / 8.0)];
        }

        public boolean get(int index) {
            if (index < 0 || index / 8 >= this.storage.length) {
                return false;
            }
            return (this.storage[index / 8] & 1 << index % 8) != 0;
        }

        public BoolArray set(int index, boolean value) {
            if (index < 0 || index / 8 >= this.storage.length || value == this.get(index)) {
                return this;
            }
            if (value) {
                int n = index / 8;
                this.storage[n] = (byte)(this.storage[n] | 1 << index % 8);
            } else {
                int n = index / 8;
                this.storage[n] = (byte)(this.storage[n] & ~(1 << index % 8));
            }
            return this;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeByteArray(this.storage);
        }

        public static BoolArray read(FriendlyByteBuf buf) {
            return new BoolArray(buf.readByteArray());
        }

        public byte[] getBytes() {
            return this.storage;
        }

        public static BoolArray fromBytes(byte[] bytes) {
            return new BoolArray(bytes);
        }

        public static BoolArray fromBytes(Byte[] bytes) {
            return new BoolArray(ArrayUtils.toPrimitive((Byte[])bytes));
        }
    }
}

