/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.init.ModItemData;

public class ItemCartModule
extends Item
implements IModuleItem {
    public ModuleData moduleData;

    public ItemCartModule(ModuleData moduleData, Item.Properties properties) {
        super(properties);
        this.moduleData = moduleData;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return Localization.translate("item.stevescarts." + this.moduleData.getRawName(), new Object[0]);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag flag) {
        if (this.moduleData != null) {
            this.moduleData.addInformation(consumer, ModItemData.getTagCopy(stack));
            if (flag.isAdvanced()) {
                consumer.accept((Component)Component.literal((String)("ID " + String.valueOf(this.moduleData.getID()))));
            }
        }
    }

    @Override
    public ModuleData getModuleData() {
        return this.moduleData;
    }

    @Override
    public void addExtraDataToCart(CompoundTag save, @Nonnull ItemStack module, int i) {
        CompoundTag tag = ModItemData.getTagCopy(module);
        if (tag.contains("Data")) {
            save.putByte("Data" + i, tag.getByteOr("Data", (byte)0));
        } else {
            IModuleItem itemCartModule = (IModuleItem)module.getItem();
            ModuleData data = itemCartModule.getModuleData();
            if (data.isUsingExtraData()) {
                save.putByte("Data" + i, data.getDefaultExtraData());
            }
        }
    }
}

