/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.IntArrayData;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleColorizer
extends ModuleAddon {
    private int markerOffsetX = 10;
    private int scrollWidth = 64;
    private int markerMoving = -1;
    private final EntityData<int[]> colors = new EntityData<int[]>(this.getCart(), new IntArrayData(new int[]{255, 255, 255}));

    public ModuleColorizer(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 125;
    }

    @Override
    public int guiHeight() {
        return 75;
    }

    private int[] getMovableMarker(int i) {
        return new int[]{this.markerOffsetX + (int)((float)this.scrollWidth * ((float)this.getColorVal(i) / 255.0f)) - 2, 17 + i * 20, 4, 13};
    }

    private int[] getArea(int i) {
        return new int[]{this.markerOffsetX, 20 + i * 20, this.scrollWidth, 7};
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/color.png");
        for (int i = 0; i < 3; ++i) {
            this.drawMarker(guiGraphics, texture, gui, x, y, i);
        }
        this.drawImage(guiGraphics, texture, gui, this.scrollWidth + 25, 29, 4, 7, 28, 28);
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        String[] colorNames = new String[]{Localization.MODULES.ADDONS.COLOR_RED.translate(new String[0]), Localization.MODULES.ADDONS.COLOR_GREEN.translate(new String[0]), Localization.MODULES.ADDONS.COLOR_BLUE.translate(new String[0])};
        for (int i = 0; i < 3; ++i) {
            this.drawStringOnMouseOver(guiGraphics, gui, colorNames[i] + ": " + this.getColorVal(i), x, y, this.getArea(i));
        }
    }

    private void drawMarker(GuiGraphics guiGraphics, ResourceLocation texture, GuiMinecart gui, int x, int y, int id) {
        float[] colorArea = new float[3];
        float[] colorMarker = new float[3];
        for (int i = 0; i < 3; ++i) {
            if (i == id) {
                colorArea[i] = 0.7f;
                colorMarker[i] = 1.0f;
                continue;
            }
            colorArea[i] = 0.2f;
            colorMarker[i] = 0.0f;
        }
        this.drawImage(guiGraphics, texture, gui, this.getArea(id), 0, 0);
        this.drawImage(guiGraphics, texture, gui, this.getMovableMarker(id), 0, 7);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            for (int i = 0; i < 3; ++i) {
                if (!this.inRect(x, y, this.getMovableMarker(i))) continue;
                this.markerMoving = i;
            }
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.markerMoving != -1) {
            int tempColor = (int)((float)(x - this.markerOffsetX) / ((float)this.scrollWidth / 255.0f));
            if (tempColor < 0) {
                tempColor = 0;
            } else if (tempColor > 255) {
                tempColor = 255;
            }
            this.sendPacket(this.markerMoving, (byte)tempColor);
        }
        if (button != -1) {
            this.markerMoving = -1;
        }
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id >= 0 && id < 3) {
            this.setColorVal(id, data[0]);
        }
    }

    public int getColorVal(int i) {
        if (this.isPlaceholder()) {
            return 255;
        }
        int tempVal = this.colors.get()[i];
        if (tempVal < 0) {
            tempVal += 256;
        }
        return tempVal;
    }

    public void setColorVal(int id, int val) {
        int[] colors = this.colors.get();
        colors[id] = val;
        this.colors.set(colors);
    }

    private float getColorComponent(int i) {
        return (float)this.getColorVal(i) / 255.0f;
    }

    @Override
    public float[] getColor() {
        return new float[]{this.getColorComponent(0), this.getColorComponent(1), this.getColorComponent(2)};
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putByte(this.generateNBTName("Red", id), (byte)this.getColorVal(0));
        output.putByte(this.generateNBTName("Green", id), (byte)this.getColorVal(1));
        output.putByte(this.generateNBTName("Blue", id), (byte)this.getColorVal(2));
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.setColorVal(0, input.getByteOr(this.generateNBTName("Red", id), (byte)0));
        this.setColorVal(1, input.getByteOr(this.generateNBTName("Green", id), (byte)0));
        this.setColorVal(2, input.getByteOr(this.generateNBTName("Blue", id), (byte)0));
    }
}

