/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotCartCrafter;
import vswe.stevescarts.containers.slots.SlotCartCrafterResult;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.modules.addons.ModuleRecipe;

public class ModuleCrafter
extends ModuleRecipe {
    private int cooldown = 0;
    private RecipeHolder<CraftingRecipe> lastRecipe = null;
    private boolean inventoryDirty = true;

    public ModuleCrafter(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public void update() {
        int j;
        ServerLevel level;
        block19: {
            block18: {
                Level level2 = this.getCart().level();
                if (!(level2 instanceof ServerLevel)) break block18;
                level = (ServerLevel)level2;
                if (this.getValidSlot() != null) break block19;
            }
            return;
        }
        if (this.inventoryDirty) {
            this.outputDisplay.set(this.getResult(level));
            this.inventoryDirty = false;
        }
        if (--this.cooldown > 0) {
            return;
        }
        this.cooldown = 40;
        ItemStack result = this.getResult(level);
        this.outputDisplay.set(result);
        if (result.isEmpty()) {
            return;
        }
        this.prepareLists();
        if (!this.canCraftMoreOfResult(result)) {
            return;
        }
        NonNullList originals = NonNullList.create();
        for (SlotStevesCarts slot : this.allTheSlots) {
            ItemStack item = slot.getItem();
            originals.add((Object)(item.isEmpty() ? ItemStack.EMPTY : item.copy()));
        }
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        boolean valid = true;
        boolean edited = false;
        for (j = 0; j < 9; ++j) {
            ItemStack recipe = this.getStack(j);
            if (recipe.isEmpty()) continue;
            valid = false;
            for (SlotStevesCarts inputSlot : this.inputSlots) {
                ItemStack stack = inputSlot.getItem();
                if (stack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)recipe) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)recipe)) continue;
                edited = true;
                ItemStack remainder = stack.getCraftingRemainder();
                if (!remainder.isEmpty()) {
                    containers.add(remainder);
                }
                stack.shrink(1);
                if (stack.getCount() <= 0) {
                    inputSlot.set(ItemStack.EMPTY);
                }
                valid = true;
                break;
            }
            if (!valid) break;
        }
        if (valid && this.getValidSlot() != null) {
            this.getCart().addItemToChest(result, this.getValidSlot(), null);
            if (result.getCount() > 0) {
                valid = false;
            } else {
                edited = true;
                for (ItemStack container : containers) {
                    if (container == null) continue;
                    this.getCart().addItemToChest(container, this.getValidSlot(), null);
                    if (container.getCount() <= 0) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (!valid && edited) {
            for (j = 0; j < this.allTheSlots.size(); ++j) {
                ((SlotStevesCarts)((Object)this.allTheSlots.get(j))).set((ItemStack)originals.get(j));
            }
        }
    }

    @Override
    public void onInventoryChanged() {
        this.inventoryDirty = true;
    }

    private CraftingInput getInput() {
        return CraftingInput.of((int)3, (int)3, (List)Lists.newArrayList((Object[])new ItemStack[]{this.getStack(0), this.getStack(1), this.getStack(2), this.getStack(3), this.getStack(4), this.getStack(5), this.getStack(6), this.getStack(7), this.getStack(8)}));
    }

    private ItemStack getResult(ServerLevel level) {
        CraftingInput input = this.getInput();
        Optional optional = level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, (Level)level, this.lastRecipe);
        if (optional.isPresent()) {
            this.lastRecipe = (RecipeHolder)optional.get();
            CraftingRecipe recipe = (CraftingRecipe)this.lastRecipe.value();
            ItemStack result = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
            if (result.isItemEnabled(level.enabledFeatures())) {
                return result;
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected int[] getArea() {
        return new int[]{68, 44, 16, 16};
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    @Override
    public int generateSlots(int slotCount) {
        this.slotGlobalStart = slotCount;
        this.slotList = new ArrayList();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.slotList.add(new SlotCartCrafter(this.getCart(), slotCount++, 10 + 18 * x, 15 + 18 * y));
            }
        }
        this.slotList.add(new SlotCartCrafterResult(this.getCart(), slotCount++, 67, this.canUseAdvancedFeatures() ? 20 : 33));
        return slotCount;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        super.drawForeground(guiGraphics, gui);
        this.setStack(9, (ItemStack)this.outputDisplay.get());
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return this.canUseAdvancedFeatures() ? 120 : 95;
    }

    @Override
    public int guiHeight() {
        return 75;
    }

    @Override
    protected boolean canUseAdvancedFeatures() {
        return false;
    }

    @Override
    protected int getLimitStartX() {
        return 90;
    }

    @Override
    protected int getLimitStartY() {
        return 23;
    }
}

