/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.creeperhost.polylib.data.serializable.BooleanData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleInvisible
extends ModuleAddon
implements IActivatorModule {
    private int[] buttonRect;
    private final EntityData<Boolean> visable = new EntityData(this.getCart(), new BooleanData(true));

    public ModuleInvisible(ModularMinecart cart) {
        super(cart);
        this.buttonRect = new int[]{20, 20, 24, 12};
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 90;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/invis.png");
        int imageID = this.isVisible() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(guiGraphics, texture, gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(guiGraphics, texture, gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, this.getStateName(), x, y, this.buttonRect);
    }

    @Override
    public void update() {
        super.update();
        if (!(this.isVisible() || this.getCart().hasFuelForModule() || this.getCart().level().isClientSide)) {
            this.setIsVisible(true);
        }
    }

    private boolean isVisible() {
        if (this.isPlaceholder()) {
            return !this.getSimInfo().getInvisActive();
        }
        return this.visable.get();
    }

    private String getStateName() {
        return Localization.MODULES.ADDONS.INVISIBILITY.translate(this.isVisible() ? "0" : "1");
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.setIsVisible(!this.isVisible());
        }
    }

    public void setIsVisible(boolean val) {
        this.visable.set(val);
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public boolean shouldCartRender() {
        return this.isVisible();
    }

    @Override
    public int getConsumption(boolean isMoving) {
        return this.isVisible() ? super.getConsumption(isMoving) : 3;
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putBoolean(this.generateNBTName("Invis", id), !this.isVisible());
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.setIsVisible(!input.getBooleanOr(this.generateNBTName("Invis", id), false));
    }

    @Override
    public void doActivate(int id) {
        this.setIsVisible(false);
    }

    @Override
    public void doDeActivate(int id) {
        this.setIsVisible(true);
    }

    @Override
    public boolean isActive(int id) {
        return !this.isVisible();
    }
}

