/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import net.creeperhost.polylib.data.serializable.ByteData;
import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.api.modules.template.ModuleTool;
import vswe.stevescarts.api.slots.SlotChest;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.LabelInformation;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleLabel
extends ModuleAddon {
    private ArrayList<LabelInformation> labels;
    private int delay = 0;
    private ArrayList<SlotStevesCarts> storageSlots;
    private ModuleTool tool;
    private final EntityData<Integer> seconds = new EntityData(this.getCart(), new IntData(0));
    private final EntityData<Byte> used = new EntityData(this.getCart(), new ByteData(0));
    private final EntityData<Integer> data = new EntityData(this.getCart(), new IntData(0));
    private final EntityData<Byte> active = new EntityData(this.getCart(), new ByteData((byte)(this.hasToolWithDurability() ? -1 : 0)));

    public ModuleLabel(ModularMinecart cart) {
        super(cart);
        this.labels = new ArrayList<1>();
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.NAME){

            @Override
            public Component getLabel() {
                return ModuleLabel.this.getCart().getName();
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.DISTANCE){

            @Override
            public Component getLabel() {
                return Component.literal((String)Localization.MODULES.ADDONS.DISTANCE_LONG.translate(String.valueOf((int)ModuleLabel.this.getCart().distanceTo((Entity)ModuleLabel.this.getClientPlayer()))));
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.POSITION){

            @Override
            public Component getLabel() {
                return Component.literal((String)Localization.MODULES.ADDONS.POSITION_LONG.translate(String.valueOf(ModuleLabel.this.getCart().x()), String.valueOf(ModuleLabel.this.getCart().y()), String.valueOf(ModuleLabel.this.getCart().z())));
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.FUEL){

            @Override
            public Component getLabel() {
                int seconds = ModuleLabel.this.seconds.get();
                if (seconds == -1) {
                    return Component.literal((String)Localization.MODULES.ADDONS.FUEL_NO_CONSUMPTION.translate(new String[0]));
                }
                int minutes = seconds / 60;
                seconds -= minutes * 60;
                int hours = minutes / 60;
                return Component.literal((String)String.format(Localization.MODULES.ADDONS.FUEL_LONG.translate(new String[0]) + ": %02d:%02d:%02d", hours, minutes -= hours * 60, seconds));
            }
        });
        this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.STORAGE){

            @Override
            public Component getLabel() {
                int used = ModuleLabel.this.used.get().byteValue();
                if (used < 0) {
                    used += 256;
                }
                return Component.literal((String)(ModuleLabel.this.storageSlots == null ? "" : Localization.MODULES.ADDONS.STORAGE.translate(new String[0]) + ": " + used + "/" + ModuleLabel.this.storageSlots.size() + (String)(ModuleLabel.this.storageSlots.size() == 0 ? "" : "[" + (int)(100.0f * (float)used / (float)ModuleLabel.this.storageSlots.size()) + "%]")));
            }
        });
    }

    @Override
    public void preInit() {
        if (this.getCart().modules() != null) {
            for (ModuleBase moduleBase : this.getCart().modules()) {
                if (!(moduleBase instanceof ModuleTool)) continue;
                this.tool = (ModuleTool)moduleBase;
                this.labels.add(new LabelInformation(Localization.MODULES.ADDONS.DURABILITY){

                    @Override
                    public Component getLabel() {
                        if (!ModuleLabel.this.tool.useDurability()) {
                            return Component.literal((String)Localization.MODULES.ADDONS.UNBREAKABLE.translate(new String[0]));
                        }
                        int data = ModuleLabel.this.data.get();
                        if (data == 0) {
                            return Component.literal((String)Localization.MODULES.ADDONS.BROKEN.translate(new String[0]));
                        }
                        if (data > 0) {
                            return Component.literal((String)(Localization.MODULES.ADDONS.DURABILITY.translate(new String[0]) + ": " + data + " / " + ModuleLabel.this.tool.getMaxDurability() + " [" + 100 * data / ModuleLabel.this.tool.getMaxDurability() + "%]"));
                        }
                        if (data == -1) {
                            return Component.empty();
                        }
                        if (data == -2) {
                            return Component.literal((String)Localization.MODULES.ADDONS.NOT_BROKEN.translate(new String[0]));
                        }
                        return Component.literal((String)(Localization.MODULES.ADDONS.REPAIR.translate(new String[0]) + " [" + -(data + 3) + "%]"));
                    }
                });
                break;
            }
        }
    }

    @Override
    public void init() {
        this.storageSlots = new ArrayList();
        for (ModuleBase module : this.getCart().modules()) {
            if (module.getSlots() == null) continue;
            for (SlotStevesCarts slot : module.getSlots()) {
                if (!(slot instanceof SlotChest)) continue;
                this.storageSlots.add(slot);
            }
        }
    }

    private boolean hasTool() {
        return this.tool != null;
    }

    private boolean hasToolWithDurability() {
        return this.hasTool() && this.tool.useDurability();
    }

    @Override
    public void addToLabel(ArrayList<Component> label) {
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!this.isActive(i)) continue;
            label.add(this.labels.get(i).getLabel());
        }
    }

    private int[] getBoxArea(int i) {
        return new int[]{10, 17 + i * 12, 8, 8};
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/label.png");
        for (int i = 0; i < this.labels.size(); ++i) {
            int[] rect = this.getBoxArea(i);
            this.drawImage(guiGraphics, texture, gui, rect, this.isActive(i) ? 8 : 0, 0);
            this.drawImage(guiGraphics, texture, gui, rect, this.inRect(x, y, rect) ? 8 : 0, 8);
        }
    }

    private boolean isActive(int i) {
        return !this.isPlaceholder() && (this.active.get() & 1 << i) != 0;
    }

    private void toggleActive(int i) {
        this.active.set((byte)(this.active.get() ^ 1 << i));
    }

    @Override
    public void update() {
        if (!this.isPlaceholder() && !this.getCart().level().isClientSide) {
            if (this.delay <= 0) {
                int data;
                if (this.isActive(3)) {
                    data = 0;
                    for (ModuleEngine engine : this.getCart().engines()) {
                        if (engine.getPriority() == 3) continue;
                        data += engine.getTotalFuel();
                    }
                    if (data != 0) {
                        int consumption = this.getCart().getConsumption();
                        data = consumption == 0 ? -1 : (data /= consumption * 20);
                    }
                    this.seconds.set(data);
                }
                if (this.isActive(4)) {
                    data = 0;
                    for (SlotStevesCarts slot : this.storageSlots) {
                        if (!slot.hasItem()) continue;
                        ++data;
                    }
                    this.used.set((byte)data);
                }
                if (this.hasToolWithDurability()) {
                    if (this.isActive(5)) {
                        if (this.tool.isRepairing()) {
                            if (this.tool.isActuallyRepairing()) {
                                this.data.set(-3 - this.tool.getRepairPercentage());
                            } else {
                                this.data.set(-2);
                            }
                        } else {
                            this.data.set(this.tool.getCurrentDurability());
                        }
                    } else if (this.data.get() != -1) {
                        this.data.set(-1);
                    }
                }
                this.delay = 20;
            } else if (this.delay > 0) {
                --this.delay;
            }
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        for (int i = 0; i < this.labels.size(); ++i) {
            int[] rect = this.getBoxArea(i);
            if (!this.inRect(x, y, rect)) continue;
            this.sendPacket(0, (byte)i);
            break;
        }
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.toggleActive(data[0]);
        }
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ADDONS.LABELS.translate(new String[0]), 8, 6, 0x404040);
        for (int i = 0; i < this.labels.size(); ++i) {
            int[] rect = this.getBoxArea(i);
            this.drawString(guiGraphics, gui, this.labels.get(i).getName(), rect[0] + 12, rect[1] + 1, 0x404040);
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int guiWidth() {
        return 92;
    }

    @Override
    public int guiHeight() {
        return 77;
    }

    @Override
    protected void load(ValueInput input, int id) {
        this.active.load(this.generateNBTName("Active", id), input);
    }

    @Override
    protected void save(ValueOutput output, int id) {
        this.active.save(this.generateNBTName("Active", id), output);
    }
}

