/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.entities.ModularMinecart;

public class ModuleMelter
extends ModuleAddon {
    private int tick;

    public ModuleMelter(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide) {
            return;
        }
        if (this.getCart().hasFuel()) {
            if (this.tick >= this.getInterval()) {
                this.tick = 0;
                this.melt();
            } else {
                ++this.tick;
            }
        }
    }

    protected int getInterval() {
        return 70;
    }

    protected int getBlocksOnSide() {
        return 7;
    }

    protected int getBlocksFromLevel() {
        return 1;
    }

    private void melt() {
        BlockPos cartPos = this.getCart().blockPosition();
        for (int x = -this.getBlocksOnSide(); x <= this.getBlocksOnSide(); ++x) {
            for (int z = -this.getBlocksOnSide(); z <= this.getBlocksOnSide(); ++z) {
                for (int y = -this.getBlocksFromLevel(); y <= this.getBlocksFromLevel(); ++y) {
                    BlockPos pos = cartPos.offset(x, y, z);
                    Block b = this.getCart().level().getBlockState(pos).getBlock();
                    this.melt(b, pos);
                }
            }
        }
    }

    protected boolean melt(Block b, BlockPos pos) {
        if (b == Blocks.SNOW) {
            this.getCart().level().removeBlock(pos, false);
            return true;
        }
        return false;
    }
}

