/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleOreTracker
extends ModuleAddon {
    public ModuleOreTracker(ModularMinecart cart) {
        super(cart);
    }

    public BlockPos findBlockToMine(ModuleDrill drill, BlockPos start) {
        return this.findBlockToMine(drill, new ArrayList<BlockPos>(), start, true);
    }

    private BlockPos findBlockToMine(ModuleDrill drill, ArrayList<BlockPos> checked, BlockPos current, boolean first) {
        if (current == null || checked.contains(current) || !first && !this.isOre(current)) {
            return null;
        }
        checked.add(current);
        if (checked.size() < 200) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos ret;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || (ret = this.findBlockToMine(drill, checked, current.offset(x, y, z), false)) == null) continue;
                        return ret;
                    }
                }
            }
        }
        if (first && !this.isOre(current)) {
            return null;
        }
        if (drill.isValidBlock(this.getCart().level(), current, 0, 1, true) == null) {
            return null;
        }
        return current;
    }

    private boolean isOre(BlockPos pos) {
        BlockState state = this.getCart().level().getBlockState(pos);
        Block b = state.getBlock();
        if (b == null || b == Blocks.AIR) {
            return false;
        }
        return state.is(Tags.Blocks.ORES);
    }
}

