/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.ShortArrayData;
import vswe.stevescarts.init.ModSerializers;
import vswe.stevescarts.polylib.EntityData;

public class ModulePowerObserver
extends ModuleAddon {
    private int currentEngine = -1;
    private final EntityData<ModSerializers.ShortArray> areaData = new EntityData<ModSerializers.ShortArray>(this.getCart(), new ShortArrayData(new ModSerializers.ShortArray(4)));
    private final EntityData<ModSerializers.ShortArray> powerLevel = new EntityData<ModSerializers.ShortArray>(this.getCart(), new ShortArrayData(new ModSerializers.ShortArray(4)));

    public ModulePowerObserver(ModularMinecart cart) {
        super(cart);
    }

    public short[] getAreaData() {
        return this.areaData.get().getArray();
    }

    public short[] getPowerLevel() {
        return this.powerLevel.get().getArray();
    }

    public void setAreaData(short[] shorts) {
        this.areaData.set(new ModSerializers.ShortArray(shorts));
    }

    public void setPowerLevel(short[] shorts) {
        this.powerLevel.set(new ModSerializers.ShortArray(shorts));
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int guiWidth() {
        return 190;
    }

    @Override
    public int guiHeight() {
        return 150;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
        for (int i = 0; i < 4; ++i) {
            int[] rect = this.getPowerRect(i);
            this.drawString(guiGraphics, gui, this.getPowerLevel()[i] + Localization.MODULES.ADDONS.K.translate(new String[0]), rect, 0x404040);
        }
    }

    private boolean removeOnPickup() {
        return true;
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        for (int i = 0; i < this.getCart().engines().size(); ++i) {
            if (this.removeOnPickup() && this.currentEngine == i) continue;
            this.drawEngine(guiGraphics, gui, i, this.getEngineRect(i));
        }
        ResourceLocation texture = ResourceHelper.getResource("/gui/observer.png");
        for (int i = 0; i < 4; ++i) {
            int[] rect = this.getAreaRect(i);
            this.drawImage(guiGraphics, texture, gui, rect, 18, 22 * i);
            if (this.inRect(x, y, rect)) {
                this.drawImage(guiGraphics, texture, gui, rect, 18, 22 * (i + 4));
            }
            int count = 0;
            for (int j = 0; j < this.getCart().engines().size(); ++j) {
                if ((this.getAreaData()[i] & 1 << j) == 0) continue;
                this.drawEngine(guiGraphics, gui, j, this.getEngineRectInArea(i, count));
                ++count;
            }
            rect = this.getPowerRect(i);
            if (this.isAreaActive(i)) {
                this.drawImage(guiGraphics, texture, gui, rect, 122, 0);
            } else {
                this.drawImage(guiGraphics, texture, gui, rect, 122 + rect[2], 0);
            }
            if (!this.inRect(x, y, rect)) continue;
            this.drawImage(guiGraphics, texture, gui, rect, 122 + rect[2] * 2, 0);
        }
        if (this.currentEngine != -1) {
            this.drawEngine(guiGraphics, gui, this.currentEngine, this.getEngineRectMouse(x, y + this.getCart().getRealScrollY()));
        }
    }

    private void drawEngine(GuiGraphics guiGraphics, GuiMinecart gui, int id, int[] rect) {
        ModuleEngine engine = this.getCart().engines().get(id);
        int initialHeight = rect[3];
        rect = this.cloneRect(rect);
        int offset = 0;
        if (!this.doStealInterface()) {
            offset = this.handleScroll(rect);
        }
        if (rect[3] <= 0) {
            return;
        }
        if (initialHeight != rect[3]) {
            gui.pushScissor();
        }
        gui.drawModuleIcon(guiGraphics, engine.getItemStack(), gui.getGuiLeft() + this.getX() + rect[0], gui.getGuiTop() + this.getY() + rect[1] + offset, 0.0f, 0.0f, 0.0f, 0.0f);
        if (initialHeight != rect[3]) {
            gui.popScissor();
        }
    }

    private int[] getAreaRect(int id) {
        return new int[]{10, 40 + 25 * id, 104, 22};
    }

    private int[] getEngineRect(int id) {
        return new int[]{11 + id * 20, 21, 16, 16};
    }

    private int[] getEngineRectMouse(int x, int y) {
        return new int[]{x - 8, y - 8, 16, 16};
    }

    private int[] getEngineRectInArea(int areaid, int number) {
        int[] area = this.getAreaRect(areaid);
        return new int[]{area[0] + 4 + number * 20, area[1] + 3, 16, 16};
    }

    private int[] getPowerRect(int areaid) {
        int[] area = this.getAreaRect(areaid);
        return new int[]{area[0] + area[2] + 10, area[1] + 2, 35, 18};
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        int i;
        for (i = 0; i < this.getCart().engines().size(); ++i) {
            if (this.removeOnPickup() && this.currentEngine == i) continue;
            ModuleEngine engine = this.getCart().engines().get(i);
            this.drawStringOnMouseOver(guiGraphics, gui, engine.getData().getName() + "\n" + Localization.MODULES.ADDONS.OBSERVER_INSTRUCTION.translate(new String[0]), x, y, this.getEngineRect(i));
        }
        for (i = 0; i < 4; ++i) {
            int count = 0;
            for (int j = 0; j < this.getCart().engines().size(); ++j) {
                if ((this.getAreaData()[i] & 1 << j) == 0) continue;
                ModuleEngine engine2 = this.getCart().engines().get(j);
                this.drawStringOnMouseOver(guiGraphics, gui, engine2.getData().getName() + "\n" + Localization.MODULES.ADDONS.OBSERVER_REMOVE.translate(new String[0]), x, y, this.getEngineRectInArea(i, count));
                ++count;
            }
            if (this.currentEngine != -1) {
                this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ADDONS.OBSERVER_DROP.translate(new String[0]), x, y, this.getAreaRect(i));
            }
            this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ADDONS.OBSERVER_CHANGE.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.OBSERVER_CHANGE_10.translate(new String[0]), x, y, this.getPowerRect(i));
        }
    }

    @Override
    public int numberOfGuiData() {
        return 8;
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            byte n;
            byte area = data[0];
            byte engine = data[1];
            short[] areaData = this.getAreaData();
            byte by = n = area;
            areaData[by] = (short)(areaData[by] | (short)(1 << engine));
            this.setAreaData(areaData);
        } else if (id == 1) {
            byte n2;
            byte area = data[0];
            byte engine = data[1];
            short[] areaData2 = this.getAreaData();
            byte by = n2 = area;
            areaData2[by] = (short)(areaData2[by] & (short)(~(1 << engine)));
            this.setAreaData(areaData2);
        } else if (id == 2) {
            int change;
            byte area = data[0];
            int button = data[1] & 1;
            boolean shift = (data[1] & 2) != 0;
            int n = change = button == 0 ? 1 : -1;
            if (shift) {
                change *= 10;
            }
            short[] powerLevel = this.getPowerLevel();
            int value = powerLevel[area];
            if ((value = (short)(value + (short)change)) < 0) {
                value = 0;
            } else if (value > 999) {
                value = 999;
            }
            powerLevel[area] = value;
            this.setPowerLevel(powerLevel);
        }
    }

    @Override
    public void mouseReleased(GuiMinecart gui, int x, int y, int button) {
        if (button != -1) {
            if (button == 0) {
                for (int i = 0; i < 4; ++i) {
                    int[] rect = this.getAreaRect(i);
                    if (!this.inRect(x, y, rect)) continue;
                    this.sendPacket(0, new byte[]{(byte)i, (byte)this.currentEngine});
                    break;
                }
            }
            this.currentEngine = -1;
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        block5: {
            int i;
            block6: {
                int[] rect;
                for (i = 0; i < 4; ++i) {
                    rect = this.getPowerRect(i);
                    if (!this.inRect(x, y, rect)) continue;
                    this.sendPacket(2, new byte[]{(byte)i, (byte)(button | (Screen.hasShiftDown() ? 2 : 0))});
                    break;
                }
                if (button != 0) break block6;
                for (i = 0; i < this.getCart().engines().size(); ++i) {
                    rect = this.getEngineRect(i);
                    if (!this.inRect(x, y, rect)) continue;
                    this.currentEngine = i;
                    break block5;
                }
                break block5;
            }
            if (button != 1) break block5;
            block2: for (i = 0; i < 4; ++i) {
                int count = 0;
                for (int j = 0; j < this.getCart().engines().size(); ++j) {
                    if ((this.getAreaData()[i] & 1 << j) == 0) continue;
                    int[] rect2 = this.getEngineRectInArea(i, count);
                    if (this.inRect(x, y, rect2)) {
                        this.sendPacket(1, new byte[]{(byte)i, (byte)j});
                        continue block2;
                    }
                    ++count;
                }
            }
        }
    }

    public boolean isAreaActive(int area) {
        int power = 0;
        for (int i = 0; i < this.getCart().engines().size(); ++i) {
            ModuleEngine engine = this.getCart().engines().get(i);
            if ((this.getAreaData()[area] & 1 << i) == 0) continue;
            power += engine.getTotalFuel();
        }
        return power > this.getPowerLevel()[area] * 1000;
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        for (int i = 0; i < 4; ++i) {
            output.putShort(this.generateNBTName("AreaData" + i, id), this.getAreaData()[i]);
            output.putShort(this.generateNBTName("PowerLevel" + i, id), this.getPowerLevel()[i]);
        }
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        short[] areaData = new short[4];
        short[] powerLevel = new short[4];
        for (int i = 0; i < 4; ++i) {
            areaData[i] = (short)input.getShortOr(this.generateNBTName("AreaData" + i, id), (short)0);
            powerLevel[i] = (short)input.getShortOr(this.generateNBTName("PowerLevel" + i, id), (short)0);
        }
        this.setAreaData(areaData);
        this.setPowerLevel(powerLevel);
    }
}

