/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotCartCrafterResult;
import vswe.stevescarts.containers.slots.SlotFurnaceInput;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.modules.addons.ModuleRecipe;

public class ModuleSmelter
extends ModuleRecipe {
    private int energyBuffer;
    private int cooldown = 0;
    private RecipeHolder<SmeltingRecipe> lastRecipe = null;
    private boolean inventoryDirty = true;

    public ModuleSmelter(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public void update() {
        ServerLevel level;
        block16: {
            block15: {
                Level level2 = this.getCart().level();
                if (!(level2 instanceof ServerLevel)) break block15;
                level = (ServerLevel)level2;
                if (this.getValidSlot() != null) break block16;
            }
            return;
        }
        ItemStack recipe = this.getStack(0);
        if (this.inventoryDirty) {
            this.outputDisplay.set(this.getResult(level, recipe));
            this.inventoryDirty = false;
        }
        if (this.getCart().hasFuelForModule() && this.energyBuffer < 10) {
            ++this.energyBuffer;
        }
        if (--this.cooldown > 0) {
            return;
        }
        this.cooldown = 40;
        if (this.energyBuffer < 10) {
            return;
        }
        ItemStack result = this.getResult(level, recipe);
        this.outputDisplay.set(result);
        if (result.isEmpty()) {
            return;
        }
        this.prepareLists();
        if (!this.canCraftMoreOfResult(result)) {
            return;
        }
        NonNullList originals = NonNullList.create();
        for (SlotStevesCarts allTheSlot : this.allTheSlots) {
            ItemStack item = allTheSlot.getItem();
            originals.add((Object)(item.isEmpty() ? ItemStack.EMPTY : item.copy()));
        }
        for (int i = 0; i < this.inputSlots.size(); ++i) {
            ItemStack item = ((SlotStevesCarts)((Object)this.inputSlots.get(i))).getItem();
            if (item.isEmpty() || !ItemStack.isSameItem((ItemStack)item, (ItemStack)recipe) || !ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)recipe)) continue;
            ItemStack itemStack = item;
            itemStack.shrink(1);
            if (itemStack.getCount() <= 0) {
                ((SlotStevesCarts)((Object)this.inputSlots.get(i))).set(ItemStack.EMPTY);
            }
            this.getCart().addItemToChest(result, this.getValidSlot(), null);
            if (result.getCount() != 0) {
                for (int j = 0; j < this.allTheSlots.size(); ++j) {
                    ((SlotStevesCarts)((Object)this.allTheSlots.get(j))).set((ItemStack)originals.get(j));
                }
                break;
            }
            this.energyBuffer = 0;
            break;
        }
    }

    @Override
    public void onInventoryChanged() {
        this.inventoryDirty = true;
    }

    private ItemStack getResult(ServerLevel level, ItemStack inputStack) {
        SingleRecipeInput input = new SingleRecipeInput(inputStack);
        Optional optional = level.getServer().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)input, (Level)level, this.lastRecipe);
        if (optional.isPresent()) {
            this.lastRecipe = (RecipeHolder)optional.get();
            SmeltingRecipe recipe = (SmeltingRecipe)this.lastRecipe.value();
            ItemStack result = recipe.assemble(input, (HolderLookup.Provider)level.registryAccess());
            if (result.isItemEnabled(level.enabledFeatures())) {
                return result;
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (this.energyBuffer < 10) {
            return 15;
        }
        return super.getConsumption(isMoving);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected int getInventoryHeight() {
        return 2;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        if (y == 0) {
            return new SlotFurnaceInput(this.getCart(), this.getCart().level(), slotId, 10 + 18 * x, 15 + 18 * y);
        }
        return new SlotCartCrafterResult(this.getCart(), slotId, 10 + 18 * x, 15 + 18 * y);
    }

    @Override
    public int numberOfGuiData() {
        return super.numberOfGuiData() + 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        super.checkGuiData(info);
        this.updateGuiData(info, super.numberOfGuiData() + 0, (short)this.energyBuffer);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        super.receiveGuiData(id, data);
        if (id == super.numberOfGuiData() + 0) {
            this.energyBuffer = data;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        super.drawForeground(guiGraphics, gui);
        this.setStack(1, (ItemStack)this.outputDisplay.get());
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return this.canUseAdvancedFeatures() ? 100 : 45;
    }

    @Override
    protected int[] getArea() {
        return new int[]{32, 25, 16, 16};
    }

    @Override
    protected boolean canUseAdvancedFeatures() {
        return false;
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.energyBuffer = input.getByteOr(this.generateNBTName("Buffer", id), (byte)0);
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putByte(this.generateNBTName("Buffer", id), (byte)this.energyBuffer);
    }

    @Override
    protected int getLimitStartX() {
        return 55;
    }

    @Override
    protected int getLimitStartY() {
        return 15;
    }
}

