/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.entities.ModularMinecart;

public class ModuleSnowCannon
extends ModuleAddon {
    private int tick;

    public ModuleSnowCannon(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide) {
            return;
        }
        if (this.getCart().hasFuel()) {
            if (this.tick >= this.getInterval()) {
                this.tick = 0;
                this.generateSnow();
            } else {
                ++this.tick;
            }
        }
    }

    protected int getInterval() {
        return 70;
    }

    protected int getBlocksOnSide() {
        return 7;
    }

    protected int getBlocksFromLevel() {
        return 1;
    }

    private void generateSnow() {
        BlockPos cartPos = this.getCart().blockPosition();
        BlockState snowState = Blocks.SNOW.defaultBlockState();
        for (int x = -this.getBlocksOnSide(); x <= this.getBlocksOnSide(); ++x) {
            for (int z = -this.getBlocksOnSide(); z <= this.getBlocksOnSide(); ++z) {
                for (int y = -this.getBlocksFromLevel(); y <= this.getBlocksFromLevel(); ++y) {
                    BlockPos pos = cartPos.offset(x, y, z);
                    if (!this.countsAsAir(pos) || this.getCart().level().getBiome(pos).is(BiomeTags.SNOW_GOLEM_MELTS) || !snowState.canSurvive((LevelReader)this.getCart().level(), pos)) continue;
                    this.getCart().level().setBlock(pos, snowState, 3);
                }
            }
        }
    }
}

