/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons.plants;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import vswe.stevescarts.api.modules.template.ModuleAddon;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModulePlantSize
extends ModuleAddon {
    private int size = 1;
    private int[] boxrect = new int[]{10, 18, 44, 44};

    public ModulePlantSize(ModularMinecart cart) {
        super(cart);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    public int guiHeight() {
        return 70;
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ADDONS.PLANTER_RANGE.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/plantsize.png");
        int srcX = (this.size - 1) % 5 * 44;
        int srcY = ((this.size - 1) / 5 + 1) * 44;
        this.drawImage(guiGraphics, texture, gui, this.boxrect, srcX, srcY);
        if (this.inRect(x, y, this.boxrect)) {
            this.drawImage(guiGraphics, texture, gui, this.boxrect, 0, 0);
        }
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ADDONS.SAPLING_AMOUNT.translate(new String[0]) + ": " + this.size + "x" + this.size, x, y, this.boxrect);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if ((button == 0 || button == 1) && this.inRect(x, y, this.boxrect)) {
            this.sendPacket(0, (byte)button);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            if (data[0] == 1) {
                --this.size;
                if (this.size < 1) {
                    this.size = 7;
                }
            } else {
                ++this.size;
                if (this.size > 7) {
                    this.size = 1;
                }
            }
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.size);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.size = data;
        }
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putByte(this.generateNBTName("size", id), (byte)this.size);
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.size = input.getByteOr(this.generateNBTName("size", id), (byte)0);
    }
}

