/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotFuel;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.polylib.FuelHelper;

public abstract class ModuleCoalBase
extends ModuleEngine {
    private int fireCoolDown;
    private int fireIndex;

    public ModuleCoalBase(ModularMinecart cart) {
        super(cart);
    }

    @Override
    protected void loadFuel() {
        int consumption = this.getCart().getConsumption(true) * 2;
        if (this.getFuelLevel() <= consumption) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                this.setFuelLevel(this.getFuelLevel() + FuelHelper.getItemBurnTime(this.getStack(i), this.getCart().level()));
                if (this.getFuelLevel() <= consumption) continue;
                if (this.getStack(i).isEmpty()) break;
                ItemStack remainder = this.getStack(i).getCraftingRemainder();
                if (!remainder.isEmpty()) {
                    this.setStack(i, remainder);
                } else {
                    ItemStack stack = this.getStack(i);
                    stack.shrink(1);
                }
                if (this.getStack(i).getCount() != 0) break;
                this.setStack(i, ItemStack.EMPTY);
                break;
            }
        }
    }

    @Override
    public int getTotalFuel() {
        int totalfuel = this.getFuelLevel();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i).isEmpty()) continue;
            totalfuel += FuelHelper.getItemBurnTime(this.getStack(i), this.getCart().level()) * this.getStack(i).getCount();
        }
        return totalfuel;
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public void smoke() {
        Vec3 velocity = this.getCart().getEffectiveVelocity().normalize();
        if (this.getCart().getRandom().nextInt(2) == 0) {
            this.getCart().level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getCart().getX() - velocity.x * 0.85, this.getCart().getY() + 0.12, this.getCart().getZ() - velocity.z * 0.85, 0.0, 0.0, 0.0);
        }
        if (this.getCart().getRandom().nextInt(30) == 0) {
            this.getCart().level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getCart().getX() - velocity.x * 0.75, this.getCart().getY() + 0.15, this.getCart().getZ() - velocity.z * 0.75, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotFuel(this.getCart(), slotId, 8 + x * 18, 23 + 18 * y);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ENGINES.COAL.translate(new String[0]), 8, 6, 0x404040);
        Object strfuel = Localization.MODULES.ENGINES.NO_FUEL.translate(new String[0]);
        if (this.getFuelLevel() > 0) {
            strfuel = "Fuel: " + this.getFuelLevel();
        }
        this.drawString(guiGraphics, gui, (String)strfuel, 8, 48, 0x404040);
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.getFuelLevel());
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.setFuelLevel(data);
            if (this.getFuelLevel() < 0) {
                this.setFuelLevel(this.getFuelLevel() + 65536);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.fireCoolDown <= 0) {
            this.fireIndex = this.getCart().getRandom().nextInt(4) + 1;
            this.fireCoolDown = 2;
        } else {
            --this.fireCoolDown;
        }
    }

    public int getFireIndex() {
        if (this.getCart().isEngineBurning()) {
            return this.fireIndex;
        }
        return 0;
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putShort(this.generateNBTName("Fuel", id), (short)this.getFuelLevel());
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.setFuelLevel(input.getShortOr(this.generateNBTName("Fuel", id), (short)0));
        if (this.getFuelLevel() < 0) {
            this.setFuelLevel(this.getFuelLevel() + 65536);
        }
    }

    public abstract double getFuelMultiplier();
}

