/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import java.util.List;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public abstract class ModuleSolarBase
extends ModuleEngine {
    private boolean maxLight;
    private int panelCoolDown;
    protected boolean down = true;
    private boolean setup;
    private final EntityData<Integer> light = new EntityData(this.getCart(), new IntData(0));
    private final EntityData<Boolean> upState = new EntityData(this.getCart(), new BooleanData(false));

    public ModuleSolarBase(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.updateSolarModel();
    }

    @Override
    protected void loadFuel() {
        this.updateLight();
        this.updateDataForModel();
        this.chargeSolar();
    }

    @Override
    public int getTotalFuel() {
        return this.getFuelLevel();
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{1.0f, 1.0f, 0.0f};
    }

    private void updateLight() {
        if (!this.getCart().level().isBrightOutside() || this.getCart().level().isRaining()) {
            this.light.set(0);
        } else if (this.getCart().level().canSeeSky(this.getCart().blockPosition())) {
            this.light.set(15);
        }
    }

    private void updateDataForModel() {
        if (this.isPlaceholder()) {
            this.light.set(this.getSimInfo().getMaxLight() ? 15 : 14);
        }
        boolean bl = this.maxLight = this.light.get() == 15;
        if (!this.upState.get().booleanValue() && this.light.get() == 15) {
            this.light.set(14);
        }
    }

    private void chargeSolar() {
        if (this.light.get() == 15 && this.getCart().level().random.nextInt(8) < 4) {
            this.setFuelLevel(this.getFuelLevel() + this.getGenSpeed());
            if (this.getFuelLevel() > this.getMaxCapacity()) {
                this.setFuelLevel(this.getMaxCapacity());
            }
        }
    }

    public int getLight() {
        return this.light.get();
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ENGINES.SOLAR.translate(new String[0]), 8, 6, 0x404040);
        Object strfuel = Localization.MODULES.ENGINES.NO_POWER.translate(new String[0]);
        if (this.getFuelLevel() > 0) {
            strfuel = "Power: " + this.getFuelLevel();
        }
        this.drawString(guiGraphics, gui, (String)strfuel, 8, 42, 0x404040);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        super.drawBackground(guiGraphics, gui, x, y);
        ResourceLocation texture = ResourceHelper.getResource("/gui/solar.png");
        int lightWidth = this.light.get() * 3;
        if (this.light.get() == 15) {
            lightWidth += 2;
        }
        this.drawImage(guiGraphics, texture, gui, 9, 20, 0, 0, 54, 18);
        this.drawImage(guiGraphics, texture, gui, 15, 21, 0, 18, lightWidth, 16);
    }

    protected boolean isGoingDown() {
        return this.down;
    }

    public void updateSolarModel() {
        if (this.getCart().level().isClientSide) {
            this.updateDataForModel();
            if (!this.setup) {
                boolean tmpUp = this.upState.get();
                if (tmpUp) {
                    this.setAnimDone();
                    this.upState.set(true);
                    this.down = false;
                }
                this.setup = true;
            }
        }
        this.panelCoolDown += this.maxLight ? 1 : -1;
        if (this.down && this.panelCoolDown < 0) {
            this.panelCoolDown = 0;
        } else if (!this.down && this.panelCoolDown > 0) {
            this.panelCoolDown = 0;
        } else if (Math.abs(this.panelCoolDown) > 20) {
            this.panelCoolDown = 0;
            this.down = !this.down;
        }
        this.upState.set(this.updatePanels());
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void doGuiDataCheck(AbstractContainerMenu con, List<Player> players, boolean isNew) {
        this.updateGuiData(con, players, isNew, 0, (short)(this.getFuelLevel() & 0xFFFF));
        this.updateGuiData(con, players, isNew, 1, (short)(this.getFuelLevel() >> 16 & 0xFFFF));
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            int dataint = data;
            if (dataint < 0) {
                dataint += 65536;
            }
            this.setFuelLevel(this.getFuelLevel() & 0xFFFF0000 | dataint);
        } else if (id == 1) {
            this.setFuelLevel(this.getFuelLevel() & 0xFFFF | data << 16);
        }
    }

    protected abstract int getMaxCapacity();

    protected abstract int getGenSpeed();

    protected abstract boolean updatePanels();

    protected abstract void setAnimDone();

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putInt(this.generateNBTName("Fuel", id), this.getFuelLevel());
        this.upState.save(this.generateNBTName("Up", id), output);
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.setFuelLevel(input.getIntOr(this.generateNBTName("Fuel", id), 0));
        this.upState.load(this.generateNBTName("Up", id), input);
        if (this.upState.get().booleanValue()) {
            this.setAnimDone();
        }
    }
}

