/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.hull;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.template.ModuleHull;
import vswe.stevescarts.entities.ModularMinecart;

public class ModulePig
extends ModuleHull {
    private int oinkTimer = this.getRandomTimer();

    public ModulePig(ModularMinecart cart) {
        super(cart);
    }

    private void oink() {
    }

    private int getRandomTimer() {
        this.oinkTimer = this.getCart().getRandom().nextInt(900) + 300;
        return this.oinkTimer;
    }

    @Override
    public void update() {
        if (this.oinkTimer <= 0) {
            this.oink();
            this.oinkTimer = this.getRandomTimer();
        } else {
            --this.oinkTimer;
        }
    }

    @Nonnull
    private ItemStack getHelmet() {
        if (this.getCart().getPassengers().isEmpty()) {
            return ItemStack.EMPTY;
        }
        Entity rider = (Entity)this.getCart().getPassengers().get(0);
        if (rider != null && rider instanceof LivingEntity) {
            return ((LivingEntity)rider).getItemBySlot(EquipmentSlot.HEAD);
        }
        return ItemStack.EMPTY;
    }

    public boolean hasHelment() {
        ItemStack item = this.getHelmet();
        return !item.isEmpty() && item.getEquipmentSlot() == EquipmentSlot.HEAD;
    }

    public ResourceLocation getHelmetResource(boolean isOverlay) {
        if (!this.hasHelment()) {
            return null;
        }
        ItemStack item = this.getHelmet();
        if (item.isEmpty()) {
            return null;
        }
        return ResourceLocation.parse((String)"");
    }

    public boolean hasHelmetColor(boolean isOverlay) {
        return this.getHelmetColor(isOverlay) != -1;
    }

    public int getHelmetColor(boolean isOverlay) {
        return -1;
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (!isMoving) {
            return super.getConsumption(isMoving);
        }
        return 1;
    }
}

