/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotCake;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleCakeServer
extends ModuleBase
implements ISuppliesModule {
    private int cooldown = 0;
    private static final int MAX_CAKES = 10;
    private static final int SLICES_PER_CAKE = 6;
    private static final int MAX_TOTAL_SLICES = 66;
    private int[] rect;
    private final EntityData<Integer> buffer = new EntityData(this.getCart(), new IntData(0));

    public ModuleCakeServer(ModularMinecart cart) {
        super(cart);
        this.rect = new int[]{40, 20, 13, 36};
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().level().isClientSide) {
            ItemStack item;
            if (this.getCart().hasCreativeSupplies()) {
                if (this.cooldown >= 20) {
                    if (this.getCakeBuffer() < 66) {
                        this.setCakeBuffer(this.getCakeBuffer() + 1);
                    }
                    this.cooldown = 0;
                } else {
                    ++this.cooldown;
                }
            }
            if (!(item = this.getStack(0)).isEmpty() && item.getItem().equals(Items.CAKE) && this.getCakeBuffer() + 6 <= 66) {
                this.setCakeBuffer(this.getCakeBuffer() + 6);
                this.setStack(0, ItemStack.EMPTY);
            }
        }
    }

    private void setCakeBuffer(int i) {
        this.buffer.set(i);
    }

    private int getCakeBuffer() {
        if (this.isPlaceholder()) {
            return 6;
        }
        return this.buffer.get();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotCake(this.getCart(), slotId, 8 + x * 18, 38 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.CAKE_SERVER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putShort(this.generateNBTName("Cake", id), (short)this.getCakeBuffer());
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.setCakeBuffer(input.getShortOr(this.generateNBTName("Cake", id), (short)0));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.CAKES.translate(String.valueOf(this.getCakes()), String.valueOf(10)) + "\n" + Localization.MODULES.ATTACHMENTS.SLICES.translate(String.valueOf(this.getSlices()), String.valueOf(6)), x, y, this.rect);
    }

    private int getCakes() {
        if (this.getCakeBuffer() == 6) {
            return 10;
        }
        return this.getCakeBuffer() / 6;
    }

    private int getSlices() {
        if (this.getCakeBuffer() == 66) {
            return 6;
        }
        return this.getCakeBuffer() % 6;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/cake.png");
        this.drawImage(guiGraphics, texture, gui, this.rect, 0, this.inRect(x, y, this.rect) ? this.rect[3] : 0);
        int maxHeight = this.rect[3] - 2;
        int height = (int)((float)this.getCakes() / 10.0f * (float)maxHeight);
        if (height > 0) {
            this.drawImage(guiGraphics, texture, gui, this.rect[0] + 1, this.rect[1] + 1 + maxHeight - height, this.rect[2], maxHeight - height, 7, height);
        }
        if ((height = (int)((float)this.getSlices() / 6.0f * (float)maxHeight)) > 0) {
            this.drawImage(guiGraphics, texture, gui, this.rect[0] + 9, this.rect[1] + 1 + maxHeight - height, this.rect[2] + 7, maxHeight - height, 3, height);
        }
    }

    @Override
    public int guiWidth() {
        return 75;
    }

    @Override
    public int guiHeight() {
        return 60;
    }

    @Override
    public boolean onInteractFirst(Player entityplayer) {
        if (this.getCakeBuffer() > 0) {
            if (!this.getCart().level().isClientSide && entityplayer.canEat(false)) {
                this.setCakeBuffer(this.getCakeBuffer() - 1);
                entityplayer.getFoodData().eat(2, 0.1f);
            }
            return true;
        }
        return false;
    }

    public int getRenderSliceCount() {
        int count = this.getSlices();
        if (count == 0 && this.getCakes() > 0) {
            count = 6;
        }
        return count;
    }

    @Override
    public boolean haveSupplies() {
        return this.getCakeBuffer() > 0;
    }
}

