/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.ResourceHelper;

public abstract class ModuleCommand
extends ModuleBase
implements CommandSource {
    private String command = "say HI";
    private int[] textbox = new int[]{10, 10, 145, 90};

    public ModuleCommand(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/command.png");
        this.drawImage(guiGraphics, texture, gui, this.textbox, 0, 0);
    }

    public void keyPress(char character, int extraInformation) {
        if (extraInformation == 14) {
            if (this.command.length() > 0) {
                this.command = this.command.substring(0, this.command.length() - 1);
            }
        } else {
            this.command = this.command + Character.toString(character);
        }
    }

    public String getCommandSenderName() {
        return "@";
    }

    public void sendChatToPlayer(String var1) {
    }

    public String translateString(String var1, Object ... var2) {
        return var1;
    }

    public BlockPos getPlayerCoordinates() {
        return this.getCart().blockPosition();
    }

    private void executeCommand() {
        if (!this.getCart().level().isClientSide) {
            // empty if block
        }
    }

    @Override
    public void moveMinecartOnRail(BlockPos pos, BlockState state) {
        if (state.getBlock() == Blocks.DETECTOR_RAIL) {
            this.executeCommand();
        }
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putString(this.generateNBTName("Command", id), this.command);
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.command = input.getStringOr(this.generateNBTName("Command", id), "");
    }
}

