/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.creeperhost.polylib.data.serializable.ByteData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotExplosion;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleDynamite
extends ModuleBase {
    private boolean markerMoving;
    private int fuseStartX;
    private int fuseStartY = 27;
    private final int maxFuseLength = 150;
    private final EntityData<Byte> fuse = new EntityData(this.getCart(), new ByteData(0));
    private final EntityData<Byte> fuseLength = new EntityData(this.getCart(), new ByteData(70));
    private final EntityData<Byte> explosion = new EntityData(this.getCart(), new ByteData(8));

    public ModuleDynamite(ModularMinecart cart) {
        super(cart);
        this.fuseStartX = super.guiWidth() + 5;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.EXPLOSIVES.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotExplosion(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.getFuse() == 0) {
            this.prime();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isPlaceholder()) {
            if (this.getFuse() == 0 && this.getSimInfo().getShouldExplode()) {
                this.setFuse(1);
            } else if (this.getFuse() != 0 && !this.getSimInfo().getShouldExplode()) {
                this.setFuse(0);
            }
        }
        if (this.getFuse() > 0) {
            this.setFuse(this.getFuse() + 1);
            if (this.getFuse() == this.getFuseLength()) {
                this.explode();
                if (!this.isPlaceholder()) {
                    this.getCart().remove(Entity.RemovalReason.KILLED);
                }
            }
        }
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + 136;
    }

    private int[] getMovableMarker() {
        return new int[]{this.fuseStartX + (int)(105.0f * (1.0f - (float)this.getFuseLength() / 150.0f)), this.fuseStartY, 4, 10};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/explosions.png");
        this.drawImage(guiGraphics, texture, gui, this.fuseStartX, this.fuseStartY + 3, 12, 0, 105, 4);
        this.drawImage(guiGraphics, texture, gui, this.fuseStartX + 105, this.fuseStartY - 4, 0, 10, 16, 16);
        this.drawImage(guiGraphics, texture, gui, this.fuseStartX + (int)(105.0f * (1.0f - (float)(this.getFuseLength() - this.getFuse()) / 150.0f)), this.fuseStartY, this.isPrimed() ? 8 : 4, 0, 4, 10);
        this.drawImage(guiGraphics, texture, gui, this.getMovableMarker(), 0, 0);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.getFuse() == 0 && this.inRect(x, y, this.getMovableMarker())) {
            this.markerMoving = true;
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.getFuse() != 0) {
            this.markerMoving = false;
        } else if (this.markerMoving) {
            int tempfuse = 150 - (int)((float)(x - this.fuseStartX) / 0.7f);
            if (tempfuse < 2) {
                tempfuse = 2;
            } else if (tempfuse > 150) {
                tempfuse = 150;
            }
            this.sendPacket(0, (byte)tempfuse);
        }
        if (button != -1) {
            this.markerMoving = false;
        }
    }

    private boolean isPrimed() {
        return this.getFuse() / 5 % 2 == 0 && this.getFuse() != 0;
    }

    private void explode() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        if (this.isPlaceholder()) {
            this.setFuse(1);
        } else {
            float f = this.explosionSize();
            this.setStack(0, ItemStack.EMPTY);
            this.getCart().level().explode(null, (double)this.getCart().blockPosition().getX(), (double)this.getCart().blockPosition().getY(), (double)this.getCart().blockPosition().getZ(), f, Level.ExplosionInteraction.TNT);
        }
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.createExplosives();
    }

    @Override
    public boolean dropOnDeath() {
        return this.getFuse() == 0;
    }

    @Override
    public void onDeath() {
        if (this.getFuse() > 0 && this.getFuse() < this.getFuseLength()) {
            this.explode();
        }
    }

    public float explosionSize() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getExplosionSize() / 2.5f;
        }
        return (float)this.explosion.get().byteValue() / 2.5f;
    }

    public void createExplosives() {
        if (this.isPlaceholder() || this.getCart().level().isClientSide) {
            return;
        }
        int f = 8;
        if (ComponentTypes.DYNAMITE.isStackOfType(this.getStack(0))) {
            f += this.getStack(0).getCount() * 2;
        }
        this.explosion.set((byte)f);
    }

    public int getFuse() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().fuse;
        }
        byte val = this.fuse.get();
        if (val < 0) {
            return val + 256;
        }
        return val;
    }

    private void setFuse(int val) {
        if (this.isPlaceholder()) {
            this.getSimInfo().fuse = val;
        } else {
            this.fuse.set((byte)val);
        }
    }

    public void setFuseLength(int val) {
        if (val > this.getMaxFuse()) {
            val = this.getMaxFuse();
        }
        this.fuseLength.set((byte)val);
    }

    public int getFuseLength() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getFuseLength();
        }
        byte val = this.fuseLength.get();
        if (val < 0) {
            return val + 256;
        }
        return val;
    }

    public void prime() {
        this.setFuse(1);
    }

    protected int getMaxFuse() {
        return 150;
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            this.setFuseLength(data[0]);
        }
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putShort(this.generateNBTName("FuseLength", id), (short)this.getFuseLength());
        output.putShort(this.generateNBTName("Fuse", id), (short)this.getFuse());
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.setFuseLength(input.getShortOr(this.generateNBTName("FuseLength", id), (short)0));
        this.setFuse(input.getShortOr(this.generateNBTName("Fuse", id), (short)0));
        this.createExplosives();
    }
}

