/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.IShearable;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.ModularMinecart;

public class ModuleFlowerRemover
extends ModuleBase {
    private int tick;
    private float bladeangle;
    private float bladespeed = 0.0f;

    public ModuleFlowerRemover(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide) {
            this.bladeangle += this.getBladeSpeed();
            this.bladespeed = this.getCart().hasFuel() ? Math.min(1.0f, this.bladespeed + 0.005f) : Math.max(0.0f, this.bladespeed - 0.005f);
            return;
        }
        if (this.getCart().hasFuel()) {
            if (this.tick >= this.getInterval()) {
                this.tick = 0;
                this.mownTheLawn();
                this.shearEntities();
            } else {
                ++this.tick;
            }
        }
    }

    protected int getInterval() {
        return 70;
    }

    protected int getBlocksOnSide() {
        return 7;
    }

    protected int getBlocksFromLevel() {
        return 1;
    }

    private void mownTheLawn() {
        BlockPos cartPos = this.getCart().blockPosition();
        BlockPos minPos = cartPos.offset(-this.getBlocksOnSide(), -this.getBlocksFromLevel(), -this.getBlocksOnSide());
        BlockPos maxPos = cartPos.offset(this.getBlocksOnSide(), this.getBlocksFromLevel(), this.getBlocksOnSide());
        ServerLevel serverLevel = (ServerLevel)this.getCart().level();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            if (!this.isMowable(pos)) continue;
            BlockState state = this.getCart().level().getBlockState(pos);
            List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)serverLevel.getBlockEntity(pos));
            this.addStuff(drops);
            this.getCart().level().removeBlock(pos, true);
        }
    }

    private void shearEntities() {
        List entities = this.getCart().level().getEntitiesOfClass(LivingEntity.class, this.getCart().getBoundingBox().inflate((double)this.getBlocksOnSide(), (double)((float)this.getBlocksFromLevel() + 2.0f), (double)this.getBlocksOnSide()));
        for (LivingEntity target : entities) {
            if (!(target instanceof IShearable)) continue;
            IShearable shearable = (IShearable)target;
            BlockPos pos = target.blockPosition();
            if (!shearable.isShearable(null, ItemStack.EMPTY, this.getCart().level(), pos)) continue;
            this.addStuff(shearable.onSheared(null, ItemStack.EMPTY, this.getCart().level(), pos));
        }
    }

    private boolean isMowable(BlockPos pos) {
        BlockState blockState = this.getCart().level().getBlockState(pos);
        return blockState.is(BlockTags.FLOWERS) || blockState.is(BlockTags.REPLACEABLE);
    }

    private void addStuff(List<ItemStack> stuff) {
        for (ItemStack stack : stuff) {
            this.getCart().addItemToChest(stack);
            if (stack.getCount() == 0) continue;
            ItemEntity entityitem = new ItemEntity(this.getCart().level(), (double)this.getCart().blockPosition().getX(), (double)this.getCart().blockPosition().getY(), (double)this.getCart().blockPosition().getZ(), stack);
            this.getCart().level().addFreshEntity((Entity)entityitem);
        }
    }

    public float getBladeAngle() {
        return this.bladeangle;
    }

    public float getBladeSpeed() {
        return this.bladespeed;
    }
}

