/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.ArrayList;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleNote
extends ModuleBase {
    private static final int maximumTracksPerModuleBitCount = 4;
    private static final int maximumNotesPerTrackBitCount = 12;
    private static final int veryLongTrackLimit = 1024;
    private static final int notesInView = 13;
    private static final int tracksInView = 5;
    private static final int[] instrumentColors = new int[]{0x404040, 0xFF0000, 65280, 255, 0xFFFF00, 65535};
    private static final String[] pitchNames = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"};
    private static final Localization.MODULES.ATTACHMENTS[] instrumentNames = new Localization.MODULES.ATTACHMENTS[]{Localization.MODULES.ATTACHMENTS.PIANO, Localization.MODULES.ATTACHMENTS.BASS_DRUM, Localization.MODULES.ATTACHMENTS.SNARE_DRUM, Localization.MODULES.ATTACHMENTS.STICKS, Localization.MODULES.ATTACHMENTS.BASS_GUITAR};
    private static final int notemapX = 70;
    private static final int notemapY = 40;
    private static final int trackHeight = 20;
    private static final int[] scrollXrect = new int[]{190, 20, 100, 16};
    private static final int[] scrollYrect = new int[]{290, 40, 16, 100};
    private static final int maximumNotesPerTrack = (int)Math.pow(2.0, 12.0) - 1;
    private static final int maximumTracksPerModule = (int)Math.pow(2.0, 4.0) - 1;
    private ArrayList<Track> tracks;
    private ArrayList<Button> buttons;
    private ArrayList<Button> instrumentbuttons;
    private int currentInstrument = -1;
    private Button createTrack;
    private Button removeTrack;
    private Button speedButton;
    private boolean isScrollingX;
    private boolean isScrollingXTune;
    private boolean isScrollingY;
    private int pixelScrollX;
    private int pixelScrollXTune;
    private int generatedScrollX;
    private int pixelScrollY;
    private int generatedScrollY;
    private int currentTick = 0;
    private int playProgress = 0;
    private boolean tooLongTrack = false;
    private boolean tooTallModule = false;
    private boolean veryLongTrack = false;
    private int speedSetting = 5;
    private final EntityData<Boolean> playing = new EntityData(this.getCart(), new BooleanData());

    public ModuleNote(ModularMinecart cart) {
        super(cart);
        this.tracks = new ArrayList();
        if (this.getCart().level().isClientSide) {
            this.buttons = new ArrayList();
            this.createTrack = new Button(10, 20);
            this.createTrack.text = Localization.MODULES.ATTACHMENTS.CREATE_TRACK.translate(new String[0]);
            this.createTrack.imageID = 0;
            this.removeTrack = new Button(30, 20);
            this.removeTrack.text = Localization.MODULES.ATTACHMENTS.REMOVE_TRACK.translate(new String[0]);
            this.removeTrack.imageID = 1;
            this.speedButton = new Button(50, 20);
            this.updateSpeedButton();
            this.instrumentbuttons = new ArrayList();
            for (int i = 0; i < 6; ++i) {
                Button tempButton = new Button(50 + (i + 1) * 20, 20);
                this.instrumentbuttons.add(tempButton);
                tempButton.text = i > 0 ? Localization.MODULES.ATTACHMENTS.ACTIVATE_INSTRUMENT.translate(instrumentNames[i - 1].translate(new String[0])) : Localization.MODULES.ATTACHMENTS.DEACTIVATE_INSTRUMENT.translate(new String[0]);
                tempButton.color = instrumentColors[i];
            }
        }
    }

    private void updateSpeedButton() {
        if (this.getCart().level().isClientSide) {
            this.speedButton.imageID = 14 - this.speedSetting;
            this.speedButton.text = Localization.MODULES.ATTACHMENTS.NOTE_DELAY.translate(String.valueOf(this.getTickDelay()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
        for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + 5); ++i) {
            Track track = this.tracks.get(i);
            for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + 13); ++j) {
                Note note = track.notes.get(j);
                note.drawText(guiGraphics, gui, i - this.getScrollY(), j - this.getScrollX());
            }
        }
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && !this.isPlaying()) {
            this.setPlaying(true);
        }
    }

    private int getTickDelay() {
        switch (this.speedSetting) {
            case 6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 2: {
                return 7;
            }
            case 1: {
                return 11;
            }
            case 0: {
                return 13;
            }
        }
        return 0;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().level().isClientSide) {
            int i;
            this.tooLongTrack = false;
            this.veryLongTrack = false;
            for (i = 0; i < this.tracks.size(); ++i) {
                Track track = this.tracks.get(i);
                if (track.notes.size() > 13) {
                    this.tooLongTrack = true;
                    if (track.notes.size() > 1024) {
                        this.veryLongTrack = true;
                    }
                }
                int trackPacketID = -1;
                if (track.addButton.down) {
                    track.addButton.down = false;
                    trackPacketID = 0;
                } else if (track.removeButton.down) {
                    track.removeButton.down = false;
                    trackPacketID = 1;
                } else if (track.volumeButton.down) {
                    track.volumeButton.down = false;
                    trackPacketID = 2;
                }
                if (trackPacketID == -1) continue;
                byte info = (byte)(i | trackPacketID << 4);
                this.sendPacket(1, info);
            }
            if (!this.tooLongTrack) {
                this.pixelScrollX = 0;
                this.isScrollingX = false;
            }
            if (!this.veryLongTrack) {
                this.pixelScrollXTune = 0;
                this.isScrollingXTune = false;
            }
            if (!(this.tooTallModule = this.tracks.size() > 5)) {
                this.pixelScrollY = 0;
                this.isScrollingY = false;
            }
            this.generateScrollX();
            this.generateScrollY();
            if (this.createTrack.down) {
                this.createTrack.down = false;
                this.sendPacket(0, (byte)0);
            }
            if (this.removeTrack.down) {
                this.removeTrack.down = false;
                this.sendPacket(0, (byte)1);
            }
            if (this.speedButton.down) {
                this.speedButton.down = false;
                this.sendPacket(0, (byte)2);
            }
            for (i = 0; i < this.instrumentbuttons.size(); ++i) {
                if (!this.instrumentbuttons.get((int)i).down || i == this.currentInstrument) continue;
                this.currentInstrument = i;
                break;
            }
            for (i = 0; i < this.instrumentbuttons.size(); ++i) {
                if (!this.instrumentbuttons.get((int)i).down || i == this.currentInstrument) continue;
                this.instrumentbuttons.get((int)i).down = false;
            }
            if (this.currentInstrument != -1 && !this.instrumentbuttons.get((int)this.currentInstrument).down) {
                this.currentInstrument = -1;
            }
        }
        if (this.isPlaying()) {
            if (this.currentTick <= 0) {
                boolean found = false;
                for (Track track2 : this.tracks) {
                    if (track2.notes.size() <= this.playProgress) continue;
                    Note note = track2.notes.get(this.playProgress);
                    float volume = 0.0f;
                    switch (track2.volume) {
                        case 0: {
                            volume = 0.0f;
                            break;
                        }
                        case 1: {
                            volume = 0.33f;
                            break;
                        }
                        case 2: {
                            volume = 0.67f;
                            break;
                        }
                        default: {
                            volume = 1.0f;
                        }
                    }
                    note.play(volume);
                    found = true;
                }
                if (!found) {
                    if (!this.getCart().level().isClientSide) {
                        this.setPlaying(false);
                    }
                    this.playProgress = 0;
                } else {
                    ++this.playProgress;
                }
                this.currentTick = this.getTickDelay() - 1;
            } else {
                --this.currentTick;
            }
        }
    }

    @Override
    public int guiWidth() {
        return 310;
    }

    @Override
    public int guiHeight() {
        return 150;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        int[] marker;
        ResourceLocation texture = ResourceHelper.getResource("/gui/note.png");
        for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + 5); ++i) {
            Track track = this.tracks.get(i);
            for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + 13); ++j) {
                Note note = track.notes.get(j);
                note.draw(guiGraphics, texture, gui, x, y, i - this.getScrollY(), j - this.getScrollX());
            }
        }
        for (Button button : this.buttons) {
            button.draw(guiGraphics, texture, gui, x, y);
        }
        if (this.tooLongTrack) {
            this.drawImage(guiGraphics, texture, gui, scrollXrect, 48, 0);
            marker = this.getMarkerX();
            this.drawImage(guiGraphics, texture, gui, marker, 148, 1);
            if (this.veryLongTrack) {
                marker = this.getMarkerXTune();
                this.drawImage(guiGraphics, texture, gui, marker, 153, 1);
            }
        } else {
            this.drawImage(guiGraphics, texture, gui, scrollXrect, 48, 16);
        }
        if (this.tooTallModule) {
            this.drawImage(guiGraphics, texture, gui, scrollYrect, 0, 48);
            marker = this.getMarkerY();
            this.drawImage(guiGraphics, texture, gui, marker, 1, 148);
        } else {
            this.drawImage(guiGraphics, texture, gui, scrollYrect, 16, 48);
        }
    }

    private int[] getMarkerX() {
        return this.generateMarkerX(this.pixelScrollX);
    }

    private int[] getMarkerXTune() {
        return this.generateMarkerX(this.pixelScrollXTune);
    }

    private int[] generateMarkerX(int x) {
        return new int[]{scrollXrect[0] + x, scrollXrect[1] + 1, 5, 14};
    }

    private void setMarkerX(int x) {
        this.pixelScrollX = this.generateNewMarkerX(x);
    }

    private void setMarkerXTune(int x) {
        this.pixelScrollXTune = this.generateNewMarkerX(x);
    }

    private int generateNewMarkerX(int x) {
        int temp = x - scrollXrect[0];
        if (temp < 0) {
            temp = 0;
        } else if (temp > scrollXrect[2] - 5) {
            temp = scrollXrect[2] - 5;
        }
        return temp;
    }

    private int getScrollX() {
        return this.generatedScrollX;
    }

    private void generateScrollX() {
        if (this.tooLongTrack) {
            int maxNotes = -1;
            for (int i = 0; i < this.tracks.size(); ++i) {
                maxNotes = Math.max(maxNotes, this.tracks.get((int)i).notes.size());
            }
            float widthOfBlockInScrollArea = (float)(scrollXrect[2] - 5) / (float)(maxNotes -= 13);
            this.generatedScrollX = Math.round((float)this.pixelScrollX / widthOfBlockInScrollArea);
            if (this.veryLongTrack) {
                this.generatedScrollX = (int)((float)this.generatedScrollX + (float)this.pixelScrollXTune / (float)(scrollXrect[2] - 5) * 50.0f);
            }
        } else {
            this.generatedScrollX = 0;
        }
    }

    private int[] getMarkerY() {
        return new int[]{scrollYrect[0] + 1, scrollYrect[1] + this.pixelScrollY, 14, 5};
    }

    private void setMarkerY(int y) {
        this.pixelScrollY = y - scrollYrect[1];
        if (this.pixelScrollY < 0) {
            this.pixelScrollY = 0;
        } else if (this.pixelScrollY > scrollYrect[3] - 5) {
            this.pixelScrollY = scrollYrect[3] - 5;
        }
    }

    private int getScrollY() {
        return this.generatedScrollY;
    }

    private void generateScrollY() {
        if (this.tooTallModule) {
            int maxTracks = this.tracks.size() - 5;
            float heightOfBlockInScrollArea = (scrollYrect[3] - 5) / maxTracks;
            this.generatedScrollY = Math.round((float)this.pixelScrollY / heightOfBlockInScrollArea);
        } else {
            this.generatedScrollY = 0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + 5); ++i) {
            Track track = this.tracks.get(i);
            for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + 13); ++j) {
                Note note = track.notes.get(j);
                if (note.instrumentId == 0) continue;
                this.drawStringOnMouseOver(guiGraphics, gui, note.toString(), x, y, note.getBounds(i - this.getScrollY(), j - this.getScrollX()));
            }
        }
        for (Button button : this.buttons) {
            if (button.text == null || button.text.length() <= 0) continue;
            button.overlay(guiGraphics, gui, x, y);
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.isScrollingX) {
            this.setMarkerX(x);
            if (button != -1) {
                this.isScrollingX = false;
            }
        }
        if (this.isScrollingXTune) {
            this.setMarkerXTune(x);
            if (button != -1) {
                this.isScrollingXTune = false;
            }
        }
        if (this.isScrollingY) {
            this.setMarkerY(y + this.getCart().getRealScrollY());
            if (button != -1) {
                this.isScrollingY = false;
            }
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int buttonId) {
        if (buttonId == 0) {
            for (Button button : this.buttons) {
                button.clicked(x, y);
            }
            if (!this.isScrollingX && this.inRect(x, y, scrollXrect)) {
                this.isScrollingX = true;
            } else if (!this.isScrollingY && this.inRect(x, y, scrollYrect)) {
                this.isScrollingY = true;
            }
        } else if (buttonId == 1 && !this.isScrollingXTune && this.inRect(x, y, scrollXrect)) {
            this.isScrollingXTune = true;
        }
        if (buttonId == 0 || buttonId == 1) {
            for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + 5); ++i) {
                Track track = this.tracks.get(i);
                for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + 13); ++j) {
                    Note note = track.notes.get(j);
                    if (!this.inRect(x, y, note.getBounds(i - this.getScrollY(), j - this.getScrollX()))) continue;
                    int instrumentInfo = this.currentInstrument;
                    if (instrumentInfo == -1) {
                        instrumentInfo = buttonId == 0 ? 6 : 7;
                    }
                    if (this.currentInstrument == -1 && note.instrumentId == 0) continue;
                    byte info = (byte)i;
                    info = (byte)(info | instrumentInfo << 4);
                    this.sendPacket(2, new byte[]{info, (byte)(j & 0xFF), (byte)(j >> 8 & 0xFF)});
                }
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        return 1 + (maximumNotesPerTrack + 1) * maximumTracksPerModule;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        short moduleHeader = (short)this.tracks.size();
        moduleHeader = (short)(moduleHeader | (short)(this.speedSetting << 4));
        this.updateGuiData(info, 0, moduleHeader);
        for (int i = 0; i < this.tracks.size(); ++i) {
            Track track = this.tracks.get(i);
            this.updateGuiData(info, 1 + (maximumNotesPerTrack + 1) * i, track.getInfo());
            for (int j = 0; j < track.notes.size(); ++j) {
                Note note = track.notes.get(j);
                this.updateGuiData(info, 1 + (maximumNotesPerTrack + 1) * i + 1 + j, note.getInfo());
            }
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            int trackCount = data & maximumTracksPerModule;
            this.speedSetting = (data & ~maximumTracksPerModule) >> 4;
            this.updateSpeedButton();
            while (this.tracks.size() < trackCount) {
                new Track();
            }
            while (this.tracks.size() > trackCount) {
                this.tracks.get(this.tracks.size() - 1).unload();
                this.tracks.remove(this.tracks.size() - 1);
            }
        } else {
            int trackId = --id / (maximumNotesPerTrack + 1);
            int noteId = id % (maximumNotesPerTrack + 1);
            Track track = this.tracks.get(trackId);
            if (noteId == 0) {
                track.setInfo(data);
            } else {
                Note note = track.notes.get(--noteId);
                note.setInfo(data);
            }
        }
    }

    private boolean isPlaying() {
        return !this.isPlaceholder() && (this.playing.get() != false || this.playProgress > 0);
    }

    private void setPlaying(boolean val) {
        this.playing.set(val);
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            if (data[0] == 0) {
                if (this.tracks.size() < maximumTracksPerModule) {
                    new Track();
                }
            } else if (data[0] == 1) {
                if (this.tracks.size() > 0) {
                    this.tracks.remove(this.tracks.size() - 1);
                }
            } else if (data[0] == 2) {
                ++this.speedSetting;
                if (this.speedSetting >= 7) {
                    this.speedSetting = 0;
                }
            }
        } else if (id == 1) {
            int trackID = data[0] & maximumTracksPerModule;
            int trackPacketID = (data[0] & ~maximumTracksPerModule) >> 4;
            if (trackID < this.tracks.size()) {
                Track track = this.tracks.get(trackID);
                if (trackPacketID == 0) {
                    if (track.notes.size() < maximumNotesPerTrack) {
                        new Note(track);
                    }
                } else if (trackPacketID == 1) {
                    if (track.notes.size() > 0) {
                        track.notes.remove(track.notes.size() - 1);
                    }
                } else if (trackPacketID == 2) {
                    track.volume = (track.volume + 1) % 4;
                }
            }
        } else if (id == 2) {
            byte info = data[0];
            short noteID = (short)(0xFF & data[1] | (data[2] & 0xFF) << 8);
            byte trackID = (byte)(info & maximumTracksPerModule);
            byte instrumentInfo = (byte)((byte)(info & ~((byte)maximumTracksPerModule)) >> 4);
            if (trackID < this.tracks.size()) {
                Track track = this.tracks.get(trackID);
                if (noteID < track.notes.size()) {
                    Note note = track.notes.get(noteID);
                    if (instrumentInfo < 6) {
                        note.instrumentId = instrumentInfo;
                    } else if (instrumentInfo == 6) {
                        ++note.pitch;
                        if (note.pitch > 24) {
                            note.pitch = 0;
                        }
                    } else {
                        --note.pitch;
                        if (note.pitch < 0) {
                            note.pitch = 24;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        short headerInfo = (short)this.tracks.size();
        headerInfo = (short)(headerInfo | (short)(this.speedSetting << 4));
        output.putShort(this.generateNBTName("Header", id), headerInfo);
        for (int i = 0; i < this.tracks.size(); ++i) {
            Track track = this.tracks.get(i);
            output.putShort(this.generateNBTName("Track" + i, id), track.getInfo());
            for (int j = 0; j < track.notes.size(); ++j) {
                Note note = track.notes.get(j);
                output.putShort(this.generateNBTName("Note" + i + ":" + j, id), note.getInfo());
            }
        }
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        short headerInfo = (short)input.getShortOr(this.generateNBTName("Header", id), (short)0);
        this.receiveGuiData(0, headerInfo);
        for (int i = 0; i < this.tracks.size(); ++i) {
            short trackInfo = (short)input.getShortOr(this.generateNBTName("Track" + i, id), (short)0);
            this.receiveGuiData(1 + (maximumNotesPerTrack + 1) * i, trackInfo);
            Track track = this.tracks.get(i);
            for (int j = 0; j < track.notes.size(); ++j) {
                short noteInfo = (short)input.getShortOr(this.generateNBTName("Note" + i + ":" + j, id), (short)0);
                this.receiveGuiData(1 + (maximumNotesPerTrack + 1) * i + 1 + j, noteInfo);
            }
        }
    }

    private class Button {
        public int[] rect;
        public boolean down = false;
        public String text;
        public int color;
        public int imageID;

        public Button(int x, int y) {
            this.rect = new int[]{x, y, 16, 16};
            this.color = 0;
            this.imageID = -1;
            ModuleNote.this.buttons.add(this);
        }

        public int[] getRect() {
            return this.rect;
        }

        public void overlay(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
            ModuleNote.this.drawStringOnMouseOver(guiGraphics, gui, this.text, x, y, this.getRect());
        }

        public void clicked(int x, int y) {
            if (ModuleNote.this.inRect(x, y, this.getRect())) {
                this.down = !this.down;
            }
        }

        public void draw(GuiGraphics guiGraphics, ResourceLocation texture, GuiMinecart gui, int x, int y) {
            if (!ModuleNote.this.inRect(x, y, this.getRect())) {
                // empty if block
            }
            ModuleNote.this.drawImage(guiGraphics, texture, gui, this.getRect(), 32, 0);
            int srcX = 0;
            int srcY = 16;
            if (this.down) {
                srcX += 16;
            }
            ModuleNote.this.drawImage(guiGraphics, texture, gui, this.getRect(), srcX, 16);
            if (this.imageID != -1) {
                ModuleNote.this.drawImage(guiGraphics, texture, gui, this.getRect(), this.imageID * 16, 32);
            }
        }
    }

    private class Track {
        public ArrayList<Note> notes = new ArrayList();
        public Button addButton;
        public Button removeButton;
        public Button volumeButton;
        public int volume = 3;
        public int lastNoteCount;

        public Track() {
            if (ModuleNote.this.getCart().level().isClientSide) {
                int ID = ModuleNote.this.tracks.size() + 1;
                this.addButton = new TrackButton(10, ID - 1);
                this.addButton.text = Localization.MODULES.ATTACHMENTS.ADD_NOTE.translate(String.valueOf(ID));
                this.addButton.imageID = 2;
                this.removeButton = new TrackButton(30, ID - 1);
                this.removeButton.text = Localization.MODULES.ATTACHMENTS.REMOVE_NOTE.translate(String.valueOf(ID));
                this.removeButton.imageID = 3;
                this.volumeButton = new TrackButton(50, ID - 1);
                this.volumeButton.text = this.getVolumeText();
                this.volumeButton.imageID = 4;
            }
            ModuleNote.this.tracks.add(this);
        }

        private String getVolumeText() {
            return Localization.MODULES.ATTACHMENTS.VOLUME.translate(String.valueOf(this.volume));
        }

        public void unload() {
            ModuleNote.this.buttons.remove(this.addButton);
            ModuleNote.this.buttons.remove(this.removeButton);
            ModuleNote.this.buttons.remove(this.volumeButton);
        }

        public short getInfo() {
            short info = 0;
            info = (short)(info | (short)this.notes.size());
            info = (short)(info | (short)(this.volume << 12));
            return info;
        }

        public void setInfo(short val) {
            int numberofNotes = val & maximumNotesPerTrack;
            while (this.notes.size() < numberofNotes) {
                new Note(this);
            }
            while (this.notes.size() > numberofNotes) {
                this.notes.remove(this.notes.size() - 1);
            }
            this.volume = (val & ~maximumNotesPerTrack) >> 12;
            if (ModuleNote.this.getCart().level().isClientSide) {
                this.volumeButton.imageID = 4 + this.volume;
                this.volumeButton.text = this.getVolumeText();
            }
        }
    }

    private class Note {
        public int instrumentId;
        public int pitch;

        public Note(Track track) {
            track.notes.add(this);
        }

        public void drawText(GuiGraphics guiGraphics, GuiMinecart gui, int trackID, int noteID) {
            if (this.instrumentId == 0) {
                return;
            }
            int[] rect = this.getBounds(trackID, noteID);
            Object str = String.valueOf(this.pitch);
            if (((String)str).length() < 2) {
                str = "0" + (String)str;
            }
            ModuleNote.this.drawString(guiGraphics, gui, (String)str, rect[0] + 3, rect[1] + 6, instrumentColors[this.instrumentId]);
        }

        public void draw(GuiGraphics guiGraphics, ResourceLocation texture, GuiMinecart gui, int x, int y, int trackID, int noteID) {
            int srcX = 0;
            if (this.instrumentId == 0) {
                srcX += 16;
            }
            int[] rect = this.getBounds(trackID, noteID);
            ModuleNote.this.drawImage(guiGraphics, texture, gui, rect, srcX, 0);
            if (ModuleNote.this.inRect(x, y, rect)) {
                ModuleNote.this.drawImage(guiGraphics, texture, gui, rect, 32, 0);
            }
        }

        public int[] getBounds(int trackID, int noteID) {
            return new int[]{70 + noteID * 16, 40 + trackID * 20, 16, 16};
        }

        public short getInfo() {
            short info = 0;
            info = (short)(info | (short)this.instrumentId);
            info = (short)(info | (short)(this.pitch << 3));
            return info;
        }

        public void setInfo(short val) {
            this.instrumentId = val & 7;
            this.pitch = (val & 0xF8) >> 3;
        }

        public void play(float volume) {
            if (this.instrumentId == 0) {
                return;
            }
            if (!ModuleNote.this.getCart().level().isClientSide) {
                if (volume > 0.0f) {
                    float calculatedPitch = (float)Math.pow(2.0, (double)(this.pitch - 12) / 12.0);
                    SoundEvent event = (SoundEvent)SoundEvents.NOTE_BLOCK_HARP.value();
                    if (this.instrumentId == 2) {
                        event = (SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value();
                    } else if (this.instrumentId == 3) {
                        event = (SoundEvent)SoundEvents.NOTE_BLOCK_SNARE.value();
                    } else if (this.instrumentId == 4) {
                        event = (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value();
                    } else if (this.instrumentId == 5) {
                        event = (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value();
                    }
                    ModuleNote.this.getCart().level().playSound(null, ModuleNote.this.getCart().blockPosition(), event, SoundSource.RECORDS, volume, calculatedPitch);
                }
            } else {
                double oX = 0.0;
                double oZ = 0.0;
                if (ModuleNote.this.getCart().getDeltaMovement().x != 0.0) {
                    oX = ModuleNote.this.getCart().getDeltaMovement().x > 0.0 ? -1 : 1;
                }
                if (ModuleNote.this.getCart().getDeltaMovement().z != 0.0) {
                    oZ = ModuleNote.this.getCart().getDeltaMovement().z > 0.0 ? -1 : 1;
                }
                ModuleNote.this.getCart().level().addParticle((ParticleOptions)ParticleTypes.NOTE, (double)ModuleNote.this.getCart().x() + oZ * 1.0 + 0.5, (double)ModuleNote.this.getCart().y() + 1.2, (double)ModuleNote.this.getCart().z() + oX * 1.0 + 0.5, (double)this.pitch / 24.0, 0.0, 0.0);
                ModuleNote.this.getCart().level().addParticle((ParticleOptions)ParticleTypes.NOTE, (double)ModuleNote.this.getCart().x() + oZ * -1.0 + 0.5, (double)ModuleNote.this.getCart().y() + 1.2, (double)ModuleNote.this.getCart().z() + oX * -1.0 + 0.5, (double)this.pitch / 24.0, 0.0, 0.0);
            }
        }

        public String toString() {
            if (this.instrumentId == 0) {
                return "Unknown instrument";
            }
            return instrumentNames[this.instrumentId - 1].translate(new String[0]) + " " + pitchNames[this.pitch];
        }
    }

    private class TrackButton
    extends Button {
        private int trackID;
        private int x;

        public TrackButton(int x, int trackID) {
            super(0, 0);
            this.trackID = trackID;
            this.x = x;
        }

        @Override
        public int[] getRect() {
            return new int[]{this.x, 40 + (this.trackID - ModuleNote.this.getScrollY()) * 20, 16, 16};
        }

        private boolean isValid() {
            return ModuleNote.this.getScrollY() <= this.trackID && this.trackID < ModuleNote.this.getScrollY() + 5;
        }

        @Override
        public void draw(GuiGraphics guiGraphics, ResourceLocation texture, GuiMinecart gui, int x, int y) {
            if (this.isValid()) {
                super.draw(guiGraphics, texture, gui, x, y);
            }
        }

        @Override
        public void overlay(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
            if (this.isValid()) {
                super.overlay(guiGraphics, gui, x, y);
            }
        }

        @Override
        public void clicked(int x, int y) {
            if (this.isValid()) {
                super.clicked(x, y);
            }
        }
    }
}

