/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.storages.tanks;

import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;

public class ModuleCheatTank
extends ModuleTank {
    private static final ChatFormatting[] colors = new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.RED, ChatFormatting.GOLD};
    private int mode;

    public ModuleCheatTank(ModularMinecart cart) {
        super(cart);
    }

    @Override
    protected String getTankInfo() {
        Object str = super.getTankInfo();
        str = (String)str + "\n\n" + Localization.MODULES.TANKS.CREATIVE_MODE.translate(colors[this.mode].toString(), String.valueOf(this.mode)) + "\n" + Localization.MODULES.TANKS.CHANGE_MODE.translate(new String[0]);
        if (this.mode != 0) {
            str = (String)str + "\n" + Localization.MODULES.TANKS.RESET_MODE.translate(new String[0]);
        }
        return str;
    }

    @Override
    protected int getTankSize() {
        return 2000000000;
    }

    @Override
    public boolean hasVisualTank() {
        return false;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        if (id == 0 && (data[0] & 1) != 0) {
            if (this.mode != 0 && (data[0] & 2) != 0) {
                this.mode = 0;
            } else if (++this.mode == colors.length) {
                this.mode = 1;
            }
            this.updateAmount();
            this.updateData();
        } else {
            super.receivePacket(id, data, player);
        }
    }

    @Override
    public int numberOfGuiData() {
        return super.numberOfGuiData() + 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        super.checkGuiData(info);
        this.updateGuiData(info, super.numberOfGuiData(), (short)this.mode);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == super.numberOfGuiData()) {
            this.mode = data;
        } else {
            super.receiveGuiData(id, data);
        }
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putByte(this.generateNBTName("mode", id), (byte)this.mode);
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.mode = input.getByteOr(this.generateNBTName("mode", id), (byte)0);
    }

    private void updateAmount() {
        if (!this.tank.getFluid().isEmpty()) {
            if (this.mode == 1) {
                this.tank.getFluid().setAmount(this.getTankSize());
            } else if (this.mode == 2) {
                this.tank.getFluid().setAmount(0);
            } else if (this.mode == 3) {
                this.tank.getFluid().setAmount(this.getTankSize() / 2);
            }
        }
    }

    @Override
    public void onFluidUpdated(int tankid) {
        this.updateAmount();
        super.onFluidUpdated(tankid);
    }

    @Override
    public boolean isFluidValid(FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    @Override
    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    @Override
    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }
}

