/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.creeperhost.polylib.data.serializable.BooleanData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBridge;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.polylib.EntityData;

public class ModuleBridge
extends ModuleWorker
implements ISuppliesModule {
    private final EntityData<Boolean> bridge = new EntityData(this.getCart(), new BooleanData(false));

    public ModuleBridge(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotBridge(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 98;
    }

    @Override
    public boolean work() {
        Level world = this.getCart().level();
        BlockPos next = this.getNextblock();
        if (this.getCart().getYTarget() < next.getY()) {
            next = next.below(2);
        } else if (this.getCart().getYTarget() == next.getY()) {
            next = next.below(1);
        }
        if (!RailBlock.isRail((Level)world, (BlockPos)next) && !RailBlock.isRail((Level)world, (BlockPos)next.below())) {
            if (this.doPreWork()) {
                if (this.tryBuildBridge(world, next, false)) {
                    this.startWorking(22);
                    this.setBridge(true);
                    return true;
                }
            } else if (this.tryBuildBridge(world, next, true)) {
                this.stopWorking();
            }
        }
        this.setBridge(false);
        return false;
    }

    private boolean tryBuildBridge(Level world, BlockPos pos, boolean doPlace) {
        Block blockAtPos = world.getBlockState(pos).getBlock();
        if ((this.countsAsAir(pos) || !world.getFluidState(pos).isEmpty()) && this.isValidForTrack(pos.above(), false)) {
            for (int slot = 0; slot < this.getInventorySize(); ++slot) {
                ItemStack stack = this.getStack(slot);
                if (stack.isEmpty() || !SlotBridge.isBridgeMaterial(stack)) continue;
                if (doPlace) {
                    Block block = Block.byItem((Item)stack.getItem());
                    boolean placed = this.getCart().level().setBlock(pos, block.defaultBlockState(), 3);
                    if (!placed) {
                        return false;
                    }
                    if (!this.getCart().hasCreativeSupplies()) {
                        stack.shrink(1);
                        if (this.getStack(slot).getCount() == 0) {
                            this.setStack(slot, ItemStack.EMPTY);
                        }
                        this.getCart().setChanged();
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void setBridge(boolean val) {
        this.bridge.set(val);
    }

    public boolean needBridge() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getNeedBridge();
        }
        return this.bridge.get();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty() || !SlotBridge.isBridgeMaterial(item)) continue;
            return true;
        }
        return false;
    }
}

