/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import java.util.ArrayList;
import net.creeperhost.polylib.data.serializable.ByteData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.storage.ValueInput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBuilder;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.polylib.EntityData;

public class ModuleRailer
extends ModuleWorker
implements ISuppliesModule {
    private boolean hasGeneratedAngles = false;
    private float[] railAngles;
    private final EntityData<Byte> rails = new EntityData(this.getCart(), new ByteData());

    public ModuleRailer(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotBuilder(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, Localization.MODULES.ATTACHMENTS.RAILER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 100;
    }

    @Override
    public boolean work() {
        BlockPos next = this.getNextblock();
        ArrayList<BlockPos> positions = this.getValidRailPositions(next);
        if (this.doPreWork()) {
            boolean foundValidPosition = false;
            for (BlockPos pos : positions) {
                if (!this.tryPlaceTrack(pos, false)) continue;
                foundValidPosition = true;
                break;
            }
            if (foundValidPosition) {
                this.startWorking(12);
            } else {
                boolean canContinue = false;
                for (BlockPos pos : positions) {
                    if (!RailBlock.isRail((Level)this.getCart().level(), (BlockPos)pos)) continue;
                    canContinue = true;
                    break;
                }
                if (!canContinue) {
                    this.turnback();
                }
            }
            return true;
        }
        this.stopWorking();
        for (BlockPos position : positions) {
            if (this.tryPlaceTrack(position, true)) break;
        }
        return false;
    }

    protected ArrayList<BlockPos> getValidRailPositions(BlockPos pos) {
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        if (pos.getY() >= this.getCart().y()) {
            lst.add(pos.above());
        }
        lst.add(pos);
        lst.add(pos.below());
        return lst;
    }

    protected boolean validRail(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        return stack.is(ItemTags.RAILS);
    }

    private boolean tryPlaceTrack(BlockPos pos, boolean doPlace) {
        if (!this.isValidForTrack(pos, true)) {
            return false;
        }
        FakePlayer fakePlayer = this.getFakePlayer();
        for (int slot = 0; slot < this.getInventorySize(); ++slot) {
            ItemStack stack = this.getStack(slot);
            if (stack.isEmpty() || !this.validRail(stack.getItem())) continue;
            if (!fakePlayer.mayUseItemAt(pos, Direction.DOWN, stack)) {
                return false;
            }
            if (doPlace) {
                Block block = Block.byItem((Item)stack.getItem());
                boolean placed = this.getCart().level().setBlock(pos, block.defaultBlockState(), 3);
                if (!placed) {
                    return false;
                }
                if (!this.getCart().hasCreativeSupplies()) {
                    stack.shrink(1);
                    this.getCart().setChanged();
                }
            }
            return true;
        }
        this.turnback();
        return true;
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateRails();
    }

    private void calculateRails() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        byte valid = 0;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i).isEmpty() || !this.validRail(this.getStack(i).getItem())) continue;
            valid = (byte)(valid + 1);
        }
        this.rails.set(valid);
    }

    public int getRails() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getRailCount();
        }
        return this.rails.get().byteValue();
    }

    public float getRailAngle(int i) {
        if (!this.hasGeneratedAngles) {
            this.railAngles = new float[this.getInventorySize()];
            for (int j = 0; j < this.getInventorySize(); ++j) {
                this.railAngles[j] = this.getCart().getRandom().nextFloat() / 2.0f - 0.25f;
            }
            this.hasGeneratedAngles = true;
        }
        return this.railAngles[i];
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.calculateRails();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty() || !this.validRail(item.getItem())) continue;
            return true;
        }
        return false;
    }
}

