/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.creeperhost.polylib.data.serializable.IntData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotTorch;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.polylib.EntityData;

public class ModuleTorch
extends ModuleWorker
implements ISuppliesModule {
    private int light;
    private int lightLimit = 8;
    private int[] boxRect;
    boolean markerMoving = false;
    private final EntityData<Integer> torches = new EntityData(this.getCart(), new IntData(0));

    public ModuleTorch(ModularMinecart cart) {
        super(cart);
        this.boxRect = new int[]{12, this.guiHeight() - 10, 46, 9};
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotTorch(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 95;
    }

    @Override
    public boolean work() {
        BlockPos next = this.getLastblock();
        ModularMinecart cart = this.getCart();
        Level world = cart.level();
        int x = next.getX();
        int y = next.getY();
        int z = next.getZ();
        int cartX = cart.x();
        int cartZ = cart.z();
        if (this.light > this.lightLimit) {
            this.stopWorking();
            return false;
        }
        block0: for (int side = -1; side <= 1; side += 2) {
            int xTorch = x + (cartZ != z ? side : 0);
            int zTorch = z + (cartX != x ? side : 0);
            for (int level = 2; level >= -2; --level) {
                BlockPos pos = new BlockPos(xTorch, y + level, zTorch);
                BlockState state = Blocks.TORCH.defaultBlockState();
                boolean canPlace = true;
                if (!state.canSurvive((LevelReader)world, pos)) {
                    canPlace = false;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        state = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)direction);
                        if (!state.canSurvive((LevelReader)world, pos)) continue;
                        canPlace = true;
                        break;
                    }
                }
                if (world.getBlockState(pos).isAir() && canPlace) {
                    for (int i = 0; i < this.getInventorySize(); ++i) {
                        if (this.getStack(i).isEmpty() || Block.byItem((Item)this.getStack(i).getItem()) != Blocks.TORCH) continue;
                        if (this.doPreWork()) {
                            this.startWorking(3);
                            return true;
                        }
                        world.setBlock(pos, state, 3);
                        if (cart.hasCreativeSupplies()) continue block0;
                        ItemStack stack = this.getStack(i);
                        stack.shrink(1);
                        if (this.getStack(i).getCount() == 0) {
                            this.setStack(i, ItemStack.EMPTY);
                        }
                        this.onInventoryChanged();
                        continue block0;
                    }
                    continue block0;
                }
                if (world.getBlockState(pos).getBlock() instanceof TorchBlock) continue block0;
            }
        }
        this.stopWorking();
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        ResourceLocation texture = ResourceHelper.getResource("/gui/torch.png");
        int barLength = 3 * this.light;
        if (this.light == 15) {
            --barLength;
        }
        int srcX = 0;
        if (this.inRect(x, y, this.boxRect)) {
            srcX += this.boxRect[2];
        }
        this.drawImage(guiGraphics, texture, gui, this.boxRect, srcX, 0);
        this.drawImage(guiGraphics, texture, gui, 13, this.guiHeight() - 10 + 1, 0, 9, barLength, 7);
        this.drawImage(guiGraphics, texture, gui, 12 + 3 * this.lightLimit, this.guiHeight() - 10, 0, 16, 1, 9);
    }

    @Override
    public void drawMouseOver(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(guiGraphics, gui, "Threshold: " + this.lightLimit + " Current: " + this.light, x, y, this.boxRect);
    }

    @Override
    public int guiHeight() {
        return super.guiHeight() + 10;
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        short data = (short)(this.light & 0xF);
        data = (short)(data | (short)((this.lightLimit & 0xF) << 4));
        this.updateGuiData(info, 0, data);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.light = data & 0xF;
            this.lightLimit = (data & 0xF0) >> 4;
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        this.lightLimit = data[0];
        if (this.lightLimit < 0) {
            this.lightLimit = 0;
        } else if (this.lightLimit > 15) {
            this.lightLimit = 15;
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.boxRect)) {
            this.generatePacket(x, y);
            this.markerMoving = true;
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.markerMoving) {
            this.generatePacket(x, y);
        }
        if (button != -1) {
            this.markerMoving = false;
        }
    }

    private void generatePacket(int x, int y) {
        int xInBox = x - this.boxRect[0];
        int val = xInBox / 3;
        if (val < 0) {
            val = 0;
        } else if (val > 15) {
            val = 15;
        }
        this.sendPacket(0, (byte)val);
    }

    public void setThreshold(byte val) {
        this.lightLimit = val;
    }

    public int getThreshold() {
        return this.lightLimit;
    }

    public int getLightLevel() {
        return this.light;
    }

    @Override
    public void update() {
        super.update();
        this.light = this.getCart().level().getLightEngine().getRawBrightness(this.getCart().blockPosition(), 15);
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateTorches();
    }

    private void calculateTorches() {
        if (this.getCart().level().isClientSide) {
            return;
        }
        int val = 0;
        for (int i = 0; i < 3; ++i) {
            val |= (!this.getStack(i).isEmpty() ? 1 : 0) << i;
        }
        this.torches.set(val);
    }

    public int getTorches() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getTorchInfo();
        }
        return this.torches.get();
    }

    @Override
    protected void save(ValueOutput output, int id) {
        super.save(output, id);
        output.putByte(this.generateNBTName("lightLimit", id), (byte)this.lightLimit);
    }

    @Override
    protected void load(ValueInput input, int id) {
        super.load(input, id);
        this.lightLimit = input.getByteOr(this.generateNBTName("lightLimit", id), (byte)0);
        this.calculateTorches();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.isEmpty() || item.getItem() != Items.TORCH) continue;
            return true;
        }
        return false;
    }
}

