/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import vswe.stevescarts.network.packets.PacketActivator;
import vswe.stevescarts.network.packets.PacketCargpManager;
import vswe.stevescarts.network.packets.PacketCreateCart;
import vswe.stevescarts.network.packets.PacketDistributorTile;
import vswe.stevescarts.network.packets.PacketEntityData;
import vswe.stevescarts.network.packets.PacketFluidSync;
import vswe.stevescarts.network.packets.PacketGuiData;
import vswe.stevescarts.network.packets.PacketMinecartButton;
import vswe.stevescarts.network.packets.PacketMinecartTurn;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);

    public static void init(IEventBus bus) {
        bus.addListener(PacketHandler::registerEvent);
    }

    public static void registerEvent(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("stevescarts").versioned(PROTOCOL_VERSION);
        registrar.playToServer(PacketCreateCart.TYPE, StreamCodec.of((buff, packet) -> packet.write((FriendlyByteBuf)buff), PacketCreateCart::read), (IPayloadHandler)new PacketCreateCart.Handler());
        registrar.playBidirectional(PacketMinecartButton.TYPE, StreamCodec.of((buff, packet) -> packet.write((FriendlyByteBuf)buff), PacketMinecartButton::read), (IPayloadHandler)new PacketMinecartButton.ServerHandler(), (IPayloadHandler)new PacketMinecartButton.ClientHandler());
        registrar.playToServer(PacketCargpManager.TYPE, StreamCodec.of((buff, packet) -> packet.write((FriendlyByteBuf)buff), PacketCargpManager::read), (IPayloadHandler)new PacketCargpManager.Handler());
        registrar.playToServer(PacketDistributorTile.TYPE, StreamCodec.of((buff, packet) -> packet.write((FriendlyByteBuf)buff), PacketDistributorTile::read), (IPayloadHandler)new PacketDistributorTile.Handler());
        registrar.playToServer(PacketActivator.TYPE, StreamCodec.of((buff, packet) -> packet.write((FriendlyByteBuf)buff), PacketActivator::read), (IPayloadHandler)new PacketActivator.Handler());
        registrar.playToClient(PacketFluidSync.TYPE, StreamCodec.of((buff, packet) -> packet.write((RegistryFriendlyByteBuf)buff), PacketFluidSync::read), (IPayloadHandler)new PacketFluidSync.Handler());
        registrar.playToServer(PacketMinecartTurn.TYPE, StreamCodec.of((buff, packet) -> packet.write((FriendlyByteBuf)buff), PacketMinecartTurn::read), (IPayloadHandler)new PacketMinecartTurn.Handler());
        registrar.playToClient(PacketGuiData.TYPE, StreamCodec.of((buff, packet) -> packet.write((FriendlyByteBuf)buff), PacketGuiData::read), (IPayloadHandler)new PacketGuiData.Handler());
        registrar.playToClient(PacketEntityData.TYPE, StreamCodec.of((buff, packet) -> packet.write((RegistryFriendlyByteBuf)buff), PacketEntityData::read), (IPayloadHandler)new PacketEntityData.Handler());
    }

    @Deprecated
    public static void sendTo(CustomPacketPayload message, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

