/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.ModularMinecart;

public class PacketMinecartButton
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PacketMinecartButton> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"cart_button"));
    private final int cartID;
    private final int id;
    private final byte[] array;

    public PacketMinecartButton(int cartID, int id, byte[] array) {
        this.cartID = cartID;
        this.id = id;
        this.array = array;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.cartID);
        buf.writeInt(this.id);
        buf.writeByteArray(this.array);
    }

    public static PacketMinecartButton read(FriendlyByteBuf buffer) {
        return new PacketMinecartButton(buffer.readInt(), buffer.readInt(), buffer.readByteArray());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSide(PacketMinecartButton msg, IPayloadContext ctx) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        PacketMinecartButton.handle(msg, (Level)level, (Player)player);
    }

    private static void handleServerSide(PacketMinecartButton msg, IPayloadContext ctx) {
        Player player = ctx.player();
        PacketMinecartButton.handle(msg, player.level(), player);
    }

    private static void handle(PacketMinecartButton msg, Level level, Player player) {
        if (level.getEntity(msg.cartID) == null) {
            return;
        }
        Entity entity = level.getEntity(msg.cartID);
        if (entity instanceof ModularMinecart) {
            ModularMinecart ModularMinecart2 = (ModularMinecart)entity;
            int id = msg.id;
            for (ModuleBase module : ModularMinecart2.modules()) {
                if (id < module.getPacketStart() || id >= module.getPacketStart() + module.totalNumberOfPackets()) continue;
                module.delegateReceivedPacket(id - module.getPacketStart(), msg.array, player);
                break;
            }
        }
    }

    public static class ServerHandler
    implements IPayloadHandler<PacketMinecartButton> {
        public void handle(PacketMinecartButton msg, IPayloadContext ctx) {
            ctx.enqueueWork(() -> PacketMinecartButton.handleServerSide(msg, ctx));
        }
    }

    public static class ClientHandler
    implements IPayloadHandler<PacketMinecartButton> {
        public void handle(PacketMinecartButton msg, IPayloadContext ctx) {
            ctx.enqueueWork(() -> PacketMinecartButton.handleClientSide(msg, ctx));
        }
    }
}

