/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.upgrades;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.client.guis.GuiUpgrade;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.containers.slots.SlotLiquidUpgradeInput;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.upgrades.InventoryUpgradeEffect;

public abstract class TankUpgradeEffect
extends InventoryUpgradeEffect {
    private static final int tankInterfaceX = 35;
    private static final int tankInterfaceY = 20;
    private static ResourceLocation texture;

    public abstract int getTankSize();

    @Override
    public Class<? extends Slot> getSlot(int id) {
        return SlotLiquidOutput.class;
    }

    @Override
    public Slot createSlot(TileEntityUpgrade upgrade, int id) {
        if (id == 0) {
            return new SlotLiquidUpgradeInput(upgrade, upgrade.tank, 16, id, this.getSlotX(id), this.getSlotY(id));
        }
        return super.createSlot(upgrade, id);
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public int getSlotX(int id) {
        return 8;
    }

    @Override
    public int getSlotY(int id) {
        return 24 * (id + 1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, TileEntityUpgrade upgrade, GuiUpgrade gui, int x, int y) {
        if (texture == null) {
            texture = ResourceHelper.getResource("/gui/tank.png");
        }
        upgrade.tank.drawFluid(guiGraphics, gui, 35, 20);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, gui.getGuiLeft() + 35, gui.getGuiTop() + 20, 0.0f, 0.0f, 36, 51, 256, 256);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(GuiGraphics guiGraphics, TileEntityUpgrade upgrade, GuiUpgrade gui, int x, int y) {
        this.drawMouseOver(guiGraphics, gui, upgrade.tank.getMouseOver(), x, y, new int[]{35, 35, 36, 51});
    }

    @Override
    public void init(TileEntityUpgrade upgrade) {
        upgrade.tank = new SCTank(upgrade, this.getTankSize(), 0);
        upgrade.getCompound().putByte("Tick", (byte)0);
    }

    @Override
    public void update(TileEntityUpgrade upgrade) {
        super.update(upgrade);
        if (upgrade.getLevel() == null) {
            return;
        }
        upgrade.getCompound().putByte("Tick", (byte)(upgrade.getCompound().getByteOr("Tick", (byte)0) - 1));
        if (upgrade.getCompound().getByteOr("Tick", (byte)0) <= 0) {
            upgrade.getCompound().putByte("Tick", (byte)5);
            if (!upgrade.getLevel().isClientSide && this.slots != null && this.slots.size() >= 2) {
                upgrade.tank.containerTransfer();
            }
        }
    }

    @Override
    public void load(TileEntityUpgrade upgrade, ValueInput input) {
        if (input.getByteOr("Exists", (byte)0) != 0) {
            upgrade.tank.deserialize(input);
        } else {
            upgrade.tank.setFluid(FluidStack.EMPTY);
        }
    }

    @Override
    public void save(TileEntityUpgrade upgrade, ValueOutput output) {
        if (upgrade.tank.getFluid().isEmpty()) {
            output.putByte("Exists", (byte)0);
        } else {
            output.putByte("Exists", (byte)1);
            upgrade.tank.serialize(output);
        }
    }
}

