// Registers a Palladium ability at id: kubejs:reds_aliens/force_field
StartupEvents.registry('palladium:abilities', (event) => {
	event.create('reds_aliens/force_field')
		.icon(palladium.createItemIcon('minecraft:shield'))

		.firstTick((entity, entry, holder, enabled) => {
			if (!enabled) return;
			// Activate cue
			entity.tell('Force field activated!');
			entity.playSound('minecraft:item.shield.block', 1.0, 1.0);
		})

		.tick((entity, entry, holder, enabled) => {
			if (!enabled) return;

			// Keep short-duration buffs rolling to simulate a shield
			// Reapplied every tick so there's no gap
			entity.potionEffects.add('minecraft:absorption', 10, 1, false, false);
			entity.potionEffects.add('minecraft:resistance', 10, 1, false, false);

			// Force field pushback - server-only, inflated bounding box, multi-API fallbacks, with debug
			try {
				if (entity.level && entity.level.isClientSide) return;
				const radius = 6.0;
				const pushStrength = 0.9;
				let box = null;
				try {
					if (typeof entity.getBoundingBox === 'function') {
						const bb = entity.getBoundingBox();
						if (bb && typeof bb.inflate === 'function') {
							box = bb.inflate(radius, radius, radius);
						}
					}
				} catch (ignore) {}
				if (!box) {
					// Fallback to constructing via class if needed
					try {
						const AABBClass = Java.loadClass('net.minecraft.world.phys.AABB');
						box = new AABBClass(
							entity.x - radius, entity.y - radius, entity.z - radius,
							entity.x + radius, entity.y + radius, entity.z + radius
						);
					} catch (ignore) {}
				}
				let nearby = [];
				try {
					if (entity.level && typeof entity.level.getEntitiesWithin === 'function') {
						nearby = entity.level.getEntitiesWithin(box) || [];
					}
				} catch (ignore) {}
				if (!nearby || nearby.length === 0) {
					try {
						if (entity.level && typeof entity.level.getEntities === 'function') {
							nearby = entity.level.getEntities(entity, box) || [];
						}
					} catch (ignore) {}
				}
				if (!nearby || nearby.length === 0) {
					try {
						if (entity.level && typeof entity.level.getEntities === 'function') {
							nearby = entity.level.getEntities(null, box) || [];
						}
					} catch (ignore) {}
				}
				if (!nearby) nearby = [];

				// Once per second, show how many entities were found (temporary debug)
				if ((entity.level.gameTime % 20) === 0) {
					entity.tell('ForceField entities: ' + nearby.length);
				}

				nearby.forEach(target => {
					if (target === entity) return;
					const dx = target.x - entity.x;
					const dz = target.z - entity.z;
					const dist = Math.sqrt(dx * dx + dz * dz) || 1.0;
					const pushX = (dx / dist) * pushStrength;
					const pushZ = (dz / dist) * pushStrength;

					// Apply velocity with guards for different mappings
					if (typeof target.push === 'function') {
						target.push(pushX, 0.2, pushZ);
					} else if (typeof target.setDeltaMovement === 'function') {
						target.setDeltaMovement(pushX, 0.2, pushZ);
					} else if (typeof target.setMotion === 'function') {
						target.setMotion(pushX, 0.2, pushZ);
					}

					// Optional visual feedback (best-effort)
					if (target.level && typeof target.level.spawnParticles === 'function') {
						target.level.spawnParticles('minecraft:enchanted_hit', target.x, target.y + 1, target.z, 2, 0.2, 0.2, 0.2, 0.05);
					}
				});
			} catch (e) {
				// Silently fail to prevent crashes
			}

			// Simple cosmetic particles around the player (server-safe)
			const r = 1.2;
			const y = entity.y + 1.0;
			for (let i = 0; i < 8; i++) {
				const angle = (Math.PI * 2 * i) / 8;
				const px = entity.x + Math.cos(angle) * r;
				const pz = entity.z + Math.sin(angle) * r;
				entity.level.spawnParticles('minecraft:small_flame', px, y, pz, 1, 0, 0, 0, 0);
			}
		})

		.lastTick((entity, entry, holder, enabled) => {
			// Runs on the last tick the ability was enabled
			entity.tell('Force field deactivated!');
			entity.playSound('minecraft:item.shield.break', 1.0, 0.9);
		});
});
