PalladiumEvents.registerAnimations((event) => {
    event.register('vax/aim', 200, (builder) => {
        let animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'punch_righthand', builder.getPartialTicks());

        if (animation > 0) {
            if (!builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setZ(4)
                    .setXRotDegrees(-100)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('easeOutCubic', animation);

                builder.get('left_arm')
                    .setXRotDegrees(-26)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(5)
                    .animate('easeOutCubic', animation);

                builder.get('body')
                    .rotateYDegrees(-45)
                    .animate('easeOutCubic', animation);

                builder.get('head')
                    .rotateYDegrees(-45)
                    .animate('easeOutCubic', animation);
            }

            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setY(-10)
                    .animate('easeOutCubic', animation);
            }
        }

        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_vaxasaurian", "punch_lefthand")) {
            let animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'punch_lefthand', builder.getPartialTicks());
            if (animation > 0) {
                if (!builder.isFirstPerson()) {
                    builder.get('right_arm')
                        .setXRotDegrees(-26)
                        .setYRotDegrees(5)
                        .setZRotDegrees(-5)
                        .animate('easeOutCubic', animation);

                    builder.get('left_arm')
                        .setXRotDegrees(-100)
                        .setZ(4)
                        .animate('easeOutCubic', animation);

                    builder.get('body')
                        .rotateYDegrees(45)
                        .animate('easeOutCubic', animation);

                    builder.get('head')
                        .rotateYDegrees(45)
                        .animate('easeOutCubic', animation);
                }

                if (builder.isFirstPerson()) {
                    builder.get('left_arm')
                        .setY(-10)
                        .animate('easeOutCubic', animation);
                }
            }
        }

    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vaxasaurian/gun_fire_anim', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'gun_fire_animtimer')) {
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setY(5)
                    .setXRotDegrees(30)
                    .setYRotDegrees(50)
                    .setZRotDegrees(-10)

                builder.get('left_arm')
                    .setY(5)
                    .setXRotDegrees(30)
                    .setYRotDegrees(-50)
                    .setZRotDegrees(10)
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('vax/earth_slam', 200, (builder) => {
        let earth_slam = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'earth_slam', builder.getPartialTicks(), 8, 16);
        builder.get('body')
            .moveY(-8)
            .animate('InOutCubic', earth_slam);
        builder.get('head')
            .setX(0)
            .setY(2.25)
            .setZ(-3)
            .rotateXDegrees(10)
            .animate('InOutCubic', earth_slam);
        builder.get('chest')
            .setX(0)
            .setY(2)
            .setZ(-3)
            .setXRotDegrees(20)
            .animate('InOutCubic', earth_slam);
        builder.get('right_arm')
            .setX(-5)
            .setY(5)
            .setZ(-3)
            .setXRotDegrees(-45)
            .setYRotDegrees(-23)
            .setZRotDegrees(19)
            .animate('InOutCubic', earth_slam);
        builder.get('left_arm')
            .setX(5)
            .setY(5)
            .setZ(-3)
            .setXRotDegrees(-45)
            .setYRotDegrees(23)
            .setZRotDegrees(-19)
            .animate('InOutCubic', earth_slam);
        builder.get('right_leg')
            .setX(-1.9)
            .setY(12)
            .setZ(-4)
            .setXRotDegrees(75)
            .animate('InOutCubic', earth_slam);
        builder.get('left_leg')
            .setX(1.9)
            .setY(7)
            .setZ(-3)
            .setXRotDegrees(10)
            .animate('InOutCubic', earth_slam);

        if (earth_slam > 0.0 && builder.isFirstPerson()) {
            builder.get('right_arm')
                .setY(10)
                .setX(15)
                .setZ(15)
                .setXRotDegrees(0)
                .setZRotDegrees(-15)
                .setYRotDegrees(-15)
                .translateZ(20)
                .translateX(30)
                .translateY(-2)
                .animate('InOutCubic', earth_slam);

            builder.get('left_arm')
                .setY(10)
                .setX(-15)
                .setZ(15)
                .setXRotDegrees(0)
                .setZRotDegrees(15)
                .setYRotDegrees(15)
                .translateZ(20)
                .translateX(-30)
                .translateY(-2)
                .animate('InOutCubic', earth_slam);
        }

        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_vaxasaurian", "earth_slam")) {
            earth_slam = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'earth_slam', builder.getPartialTicks(), 1, 7);
            if (earth_slam > 0.0 && !builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(-180)
                    .setZRotDegrees(-5)
                    .animate('InOutCubic', earth_slam);

                builder.get('left_arm')
                    .setXRotDegrees(-180)
                    .setZRotDegrees(5)
                    .animate('InOutCubic', earth_slam);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('vax/tail_spin', 200, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_vaxasaurian", "tail_spin")) {
            const progress_spin_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'tail_spin', builder.getPartialTicks());
            if (progress_spin_1 > 0 && !builder.isFirstPerson()) {
                builder.get('chest').rotateXDegrees(40).animate('easeOutCubic', progress_spin_1);
                builder.get('chest').setY(5).animate('easeOutCubic', progress_spin_1);
                builder.get('head').setY(8).animate('easeOutCubic', progress_spin_1);
                builder.get('right_arm').setY(5).animate('easeOutCubic', progress_spin_1);
                builder.get('left_arm').setY(5).animate('easeOutCubic', progress_spin_1);
                builder.get('right_leg').setZ(5).animate('easeOutCubic', progress_spin_1);
                builder.get('left_leg').setZ(5).animate('easeOutCubic', progress_spin_1);
            }
        }

        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_vaxasaurian", "tail_spin")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'tail_spin', builder.getPartialTicks());
            if (progress_spin > 0 && !builder.isFirstPerson()) {
                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
ClientEvents.tick(event => {
    if (abilityUtil.hasPower(event.player, "evo_reds_alienpack_ult:ult_vaxasaurian")) {
        if (abilityUtil.isEnabled(event.player, "evo_reds_alienpack_ult:ult_vaxasaurian", "tail_spin")) {
            let mode = Client.options.getCameraType();
            if (mode !== 'third_person_back' && mode !== 'third_person_front') {
                event.player.persistentData.camera_reset = 1;
                Client.options.setCameraType('third_person_back');
            }
        }

        let end = event.player.persistentData.camera_reset;
        if (!abilityUtil.isEnabled(event.player, "evo_reds_alienpack_ult:ult_vaxasaurian", "tail_spin") && end === 1) {
            event.player.persistentData.camera_reset = 0;
            Client.options.setCameraType('first_person');
        }
    }
});

PalladiumEvents.registerAnimations((event) => {
    event.register('vax/block', 15, (builder) => {
        let block_anim = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vaxasaurian', 'block_abil', builder.getPartialTicks());
        if (block_anim > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', block_anim);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', block_anim);
        }
        if (block_anim > 0.0 && builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', block_anim);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', block_anim);
        } else {
        }
    });
});
