function spawnHotdogMonster(server, spawnx, spawny, spawnz) {
    try {
        console.log(`Attempting to spawn hotdog monster at ${spawnx}, ${spawny}, ${spawnz}`);
        
        // Add delay before spawning
        setTimeout(() => {
            const summonResult = server.runCommandSilent(`summon minecraft:husk ${spawnx} ${spawny} ${spawnz} {CustomName:'{"text":"Hotdog Alien"}',CustomNameVisible:0b,Tags:["hotdog_monster"],LeftHanded:0b,ArmorItems:[{},{},{id:"evo_reds_alienpack:alien_meat_bits",Count:1},{}],DeathLootTable:"minecraft:empty"}`);
            console.log(`Summon result: ${summonResult}`);
            
            // Apply superpower and tags after a small delay to ensure entity is spawned
            setTimeout(() => {
                console.log('Applying superpower and tags...');
                const powerResult = server.runCommandSilent(`superpower add reds_things:hotdog_monster @e[type=minecraft:husk,tag=hotdog_monster,tag=!hotdog_powered,limit=1,sort=nearest]`);
                console.log(`Superpower result: ${powerResult}`);
                
                const tagResult = server.runCommandSilent(`tag @e[type=minecraft:husk,tag=hotdog_monster,tag=!hotdog_powered,limit=1,sort=nearest] add hotdog_powered`);
                console.log(`Tag result: ${tagResult}`);
                
                const armorResult = server.runCommandSilent(`data modify entity @e[type=minecraft:husk,tag=hotdog_monster,limit=1,sort=nearest] ArmorDropChances set value [0.0f,0.0f,1.0f,0.0f]`);
                console.log(`Armor result: ${armorResult}`);
            }, 100);
        }, 5000);
        
        return true;
    } catch (error) {
        console.log('Error spawning hotdog monster: ' + error.message);
        return false;
    }
}

ItemEvents.rightClicked('evo_reds_alienpack:alien_beacon', event => {
    console.log('Alien beacon right-clicked by: ' + event.entity.username);
    console.log('Item ID: ' + event.item.id);
    
    if (event.entity.isPlayer()) {
        // Play sound immediately using command
        event.server.runCommandSilent(`playsound evo_reds_alienpack:signal master @a ${event.entity.x} ${event.entity.y} ${event.entity.z} 1.0 1.0`);
        
        // Show message and consume item immediately
        event.entity.tell('§6Sending Signal...');
        event.item.shrink(1);
        
        // Get coordinates for spawning
        const { x: spawnx, y: spawny, z: spawnz } = event.entity;
        
        // Spawn immediately
        if (!spawnHotdogMonster(event.server, spawnx, spawny, spawnz)) {
            event.entity.tell('§cError...');
            event.server.runCommandSilent('reload');
        }
    }
});