// Hotdog Monster Spawning System

// Function to spawn hotdog monster at given coordinates
function spawnHotdogMonster(server, x, y, z) {
    try {
        server.runCommandSilent(`summon minecraft:husk ${x} ${y} ${z} {CustomName:'{"text":"Hotdog Monster"}',CustomNameVisible:0b,Tags:["hotdog_monster"],LeftHanded:0b,ArmorItems:[{},{},{id:"evo_reds_alienpack:alien_meat_bits",Count:1},{}],DeathLootTable:"minecraft:empty"}`);
        
        setTimeout(() => {
            server.runCommandSilent(`superpower add reds_things:hotdog_monster @e[type=minecraft:husk,tag=hotdog_monster,tag=!hotdog_powered,limit=1,sort=nearest]`);
            server.runCommandSilent(`tag @e[type=minecraft:husk,tag=hotdog_monster,tag=!hotdog_powered,limit=1,sort=nearest] add hotdog_powered`);
            server.runCommandSilent(`data modify entity @e[type=minecraft:husk,tag=hotdog_monster,limit=1,sort=nearest] ArmorDropChances set value [0.0f,0.0f,1.0f,0.0f]`);
        }, 250);
        
        return true;
    } catch (error) {
        console.log('Error spawning hotdog monster: ' + error.message);
        return false;
    }
}

// Function to find spawn location
function findSpawnLocation(player, distance, angle) {
    const pos = player.position;
    const spawnX = Math.floor(pos.x + Math.cos(angle) * distance);
    const spawnZ = Math.floor(pos.z + Math.sin(angle) * distance);
    
    let spawnY = 0;
    for (let y = 255; y >= 0; y--) {
        const block = player.level.getBlock(spawnX, y, spawnZ);
        if (block && !block.isAir() && block.isSolid()) {
            spawnY = y + 1;
            break;
        }
    }
    
    if (spawnY < 60 || spawnY > 200) return null;
    
    return { x: spawnX, y: spawnY, z: spawnZ };
}

// Natural spawning
ServerEvents.tick(event => {
    if (event.server.getTickCount() % 200 !== 0) return;
    
    const players = event.server.getPlayers();
    if (players.length === 0) return;
    
    if (Math.random() > 0.01) return;
    
    const player = players[Math.floor(Math.random() * players.length)];
    const distance = 20 + Math.random() * 30;
    const angle = Math.random() * 2 * Math.PI;
    
    const location = findSpawnLocation(player, distance, angle);
    if (!location) return;
    
    const nearby = player.level.getEntitiesOfType('minecraft:husk').filter(entity => 
        entity.hasTag('hotdog_monster') && 
        entity.distanceTo({x: location.x, y: location.y, z: location.z}) < 50
    );
    
    if (nearby.length >= 3) return;
    
    if (spawnHotdogMonster(event.server, location.x, location.y, location.z)) {
        const nearbyPlayers = players.filter(p => p.distanceTo({x: location.x, y: location.y, z: location.z}) < 100);
        nearbyPlayers.forEach(p => {
            p.tell('§6A Hotdog Monster has spawned nearby!');
        });
    }
});

// Commands
ServerEvents.commandRegistry(event => {
    const { commands: Commands } = event;
    const { literal } = Commands;

    event.register(
        literal('alienspawn')
            .then(
                literal('hotdog').executes(ctx => {
                    const player = ctx.source.player;
                    const { x, y, z } = player;
                    
                    if (spawnHotdogMonster(ctx.source.server, x, y, z)) {
                        player.tell('§aHotdog Monster spawned!');
                    } else {
                        player.tell('§cError spawning hotdog monster!');
                    }
                    
                    return 1;
                })
                .then(
                    literal('natural').executes(ctx => {
                        const player = ctx.source.player;
                        const distance = 20 + Math.random() * 30;
                        const angle = Math.random() * 2 * Math.PI;
                        
                        const location = findSpawnLocation(player, distance, angle);
                        if (!location) {
                            player.tell('§cNo suitable location found!');
                            return 1;
                        }
                        
                        if (spawnHotdogMonster(ctx.source.server, location.x, location.y, location.z)) {
                            player.tell(`§aHotdog Monster spawned at ${location.x}, ${location.y}, ${location.z}!`);
                        } else {
                            player.tell('§cError spawning hotdog monster!');
                        }
                        
                        return 1;
                    })
                )
            )
    );
});