// Global variables to store the gamerule settings
global.recalGiveAFAliens = global.recalGiveAFAliens || true;
global.recalRandomizeBugRecal = global.recalRandomizeBugRecal || false;

// Register the custom command
ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event;

    event.register(
        Commands.literal('omnievogamerule')
            .then(
                Commands.literal('giveafaliens')
                    .then(
                        Commands.argument('state', Arguments.BOOLEAN.create(event))
                            .executes(ctx => {
                                const state = Arguments.BOOLEAN.getResult(ctx, 'state');
                                global.recalGiveAFAliens = state;
                                
                                if (state) {
                                    // Give all players the tag and remove disable tag
                                    Utils.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
                                    Utils.server.runCommandSilent('tag @a remove Recal.DisableAutoTag');
                                    ctx.source.sendSuccess(Text.of('§a[Omni-Evo] GiveAFAliens set to true. All players now gain AF aliens on recal.'), false);
                                } else {
                                    // Remove the tag from all players and add disable tag
                                    Utils.server.runCommandSilent('tag @a remove Recal.GiveAFAliens');
                                    Utils.server.runCommandSilent('tag @a add Recal.DisableAutoTag');
                                    ctx.source.sendSuccess(Text.of('§c[Omni-Evo] GiveAFAliens set to false. All players dont gain AF aliens on recal.'), false);
                                }
                                
                                return 1;
                            })
                    )
            )
            .then(
                Commands.literal('randomizebugrecal')
                    .then(
                        Commands.argument('state', Arguments.BOOLEAN.create(event))
                            .executes(ctx => {
                                const state = Arguments.BOOLEAN.getResult(ctx, 'state');
                                global.recalRandomizeBugRecal = state;
                                
                                if (state) {
                                    Utils.server.runCommandSilent('tag @a add Recal.RandomizeBugRecal');
                                    Utils.server.runCommandSilent('tag @a remove Recal.DisableRandomizeBugRecal');
                                    ctx.source.sendSuccess(Text.of('§a[Omni-Evo] RandomizeBugRecal set to true. Bug recal will be randomized.'), false);
                                } else {
                                    Utils.server.runCommandSilent('tag @a remove Recal.RandomizeBugRecal');
                                    Utils.server.runCommandSilent('tag @a add Recal.DisableRandomizeBugRecal');
                                    ctx.source.sendSuccess(Text.of('§c[Omni-Evo] RandomizeBugRecal set to false. Bug recal will not be randomized.'), false);
                                }
                                
                                return 1;
                            })
                    )
            )
            .executes(ctx => {
                ctx.source.sendSuccess(Text.of('§e[Omni-Evo] Current settings:\n§eGiveAFAliens: ' + (global.recalGiveAFAliens ? 'true' : 'false') + '\n§eRandomizeBugRecal: ' + (global.recalRandomizeBugRecal ? 'true' : 'false')), false);
                return 1;
            })
    );
});

// World start event - give all players the tag if the setting is true
ServerEvents.loaded(event => {
    console.log('[Omni-Evo] World loaded event triggered');
    if (global.recalGiveAFAliens) {
        // Try multiple approaches to ensure the tag gets applied
        event.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
        Utils.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
        console.log('[Omni-Evo] World loaded - GiveAFAliens is enabled, all players have been given the Recal.GiveAFAliens tag');
    }
    if (global.recalRandomizeBugRecal) {
        // Try multiple approaches to ensure the tag gets applied
        event.server.runCommandSilent('tag @a add Recal.RandomizeBugRecal');
        Utils.server.runCommandSilent('tag @a add Recal.RandomizeBugRecal');
        console.log('[Omni-Evo] World loaded - RandomizeBugRecal is enabled, all players have been given the Recal.RandomizeBugRecal tag');
    } else {
        // Ensure disable tag is applied when setting is false
        event.server.runCommandSilent('tag @a add Recal.DisableRandomizeBugRecal');
        Utils.server.runCommandSilent('tag @a add Recal.DisableRandomizeBugRecal');
        console.log('[Omni-Evo] World loaded - RandomizeBugRecal is disabled, all players have been given the Recal.DisableRandomizeBugRecal tag');
    }
});

// Alternative server start event
ServerEvents.tick(event => {
    // Only run once when server starts
    if (!global.recalInitialized) {
        global.recalInitialized = true;
        console.log('[Omni-Evo] Server tick initialization');
        if (global.recalGiveAFAliens) {
            event.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
            console.log('[Omni-Evo] Server tick - GiveAFAliens is enabled, all players have been given the Recal.GiveAFAliens tag');
        }
        if (global.recalRandomizeBugRecal) {
            event.server.runCommandSilent('tag @a add Recal.RandomizeBugRecal');
            console.log('[Omni-Evo] Server tick - RandomizeBugRecal is enabled, all players have been given the Recal.RandomizeBugRecal tag');
        } else {
            event.server.runCommandSilent('tag @a add Recal.DisableRandomizeBugRecal');
            console.log('[Omni-Evo] Server tick - RandomizeBugRecal is disabled, all players have been given the Recal.DisableRandomizeBugRecal tag');
        }
    }
});

// Player join event - give new players the tag if the setting is true
PlayerEvents.loggedIn(event => {
    console.log('[Omni-Evo] Player ' + event.player.name + ' joined');
    if (global.recalGiveAFAliens) {
        event.player.runCommandSilent('tag @s add Recal.GiveAFAliens');
        event.server.runCommandSilent('tag ' + event.player.name + ' add Recal.GiveAFAliens');
        console.log('[Omni-Evo] Player ' + event.player.name + ' joined - GiveAFAliens is enabled, player has been given the Recal.GiveAFAliens tag');
    }
    if (global.recalRandomizeBugRecal) {
        event.player.runCommandSilent('tag @s add Recal.RandomizeBugRecal');
        event.server.runCommandSilent('tag ' + event.player.name + ' add Recal.RandomizeBugRecal');
        console.log('[Omni-Evo] Player ' + event.player.name + ' joined - RandomizeBugRecal is enabled, player has been given the Recal.RandomizeBugRecal tag');
    } else {
        event.player.runCommandSilent('tag @s add Recal.DisableRandomizeBugRecal');
        event.server.runCommandSilent('tag ' + event.player.name + ' add Recal.DisableRandomizeBugRecal');
        console.log('[Omni-Evo] Player ' + event.player.name + ' joined - RandomizeBugRecal is disabled, player has been given the Recal.DisableRandomizeBugRecal tag');
    }
});
