// SERVER: Remove galvanic_mechamorph (by numeric ID) if player has a power
PlayerEvents.tick(event => {
    const player = event.player;
    if (!player) return;

    // --- CONFIG ---
    const TARGET_POWER = "alienevo:reboottwo_omnitrix";
    const TARGET_ALIEN_RESOURCE = "alienevo_aliens:galvanic_mechamorph";
    const OMNITRIX_PROPERTY_KEY = "omnitrix_cycle";
    const CURRENT_PLAYLIST_KEY = "current_playlist";
    const CURRENT_ALIEN_SLOT_KEY = "current_alien_slot";
    const MAX_PLAYLISTS = 10;
    const MAX_SLOTS = 10;

    // Power check
    if (!palladium.abilities.hasPower(player, TARGET_POWER)) return;

    // Lookup alien number
    let targetAlienNumber = -1;
    for (let i = 1; i <= 300; i++) {
        if (!global[`alienevo_alien_${i}`]) continue;

        let entry = global[`alienevo_alien_${i}`][0];
        if (!entry) continue;

        let entryLower = entry.toLowerCase();
        if (entryLower === TARGET_ALIEN_RESOURCE.toLowerCase()
            || entryLower.split(":").pop() === TARGET_ALIEN_RESOURCE.split(":").pop().toLowerCase()) {
            targetAlienNumber = i;
            break;
        }
    }

    if (targetAlienNumber === -1) return;

    // Track if anything was removed
    let removedAnything = false;

    // Remove from playlists
    for (let p = 1; p <= MAX_PLAYLISTS; p++) {
        for (let s = 1; s <= MAX_SLOTS; s++) {
            let key = `alienevo.alien_${p}_${s}`;
            if (player.persistentData.getInt(key) === targetAlienNumber) {
                player.persistentData.putInt(key, 0);
                removedAnything = true;
            }
        }
    }

    // Active alien check
    const activePlaylist = player.persistentData.getInt(CURRENT_PLAYLIST_KEY) || 1;
    const activeSlot = player.persistentData.getInt(CURRENT_ALIEN_SLOT_KEY) || 1;
    const activeKey = `alienevo.alien_${activePlaylist}_${activeSlot}`;

    if (player.persistentData.getInt(activeKey) === targetAlienNumber) {
        player.persistentData.putInt(activeKey, 0);
        palladium.setProperty(player, OMNITRIX_PROPERTY_KEY, 0);
        removedAnything = true;
    }

    // Update Palladium properties
    for (let slot = 1; slot <= MAX_SLOTS; slot++) {
        let type = player.persistentData.getInt(`alienevo.alien_${activePlaylist}_${slot}`) || 0;
        palladium.setProperty(player, `alien_evo_slot_${slot}`, type);
    }

    // Send message ONLY if the alien was removed
    if (removedAnything) {
        player.tell(Text.of("§cSorry, this DNA is corrupted, try again later."));
    }
});
