ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event;

    const OMNITRIX_PROPERTY_KEY = "omnitrix_cycle";
    const CURRENT_PLAYLIST_KEY = "current_playlist";
    const CURRENT_ALIEN_SLOT_KEY = "current_alien_slot";
    const MAX_PLAYLISTS = 10;
    const MAX_ALIEN_SLOTS = 10;

    const alienSuggestionProvider = (context, builder) => {
        const input = context.getInput().split(" ").pop().toLowerCase();
        let aliens = [];

        for (let i = 1; i <= 300; i++) {
            if (global[`alienevo_alien_${i}`]) {
                let alienName = global[`alienevo_alien_${i}`][0];
                aliens.push({
                    name: alienName,
                    id: i,
                    score: alienName.toLowerCase().startsWith(input) ? 0 : 1
                });
            }
        }

        aliens.sort((a, b) => {
            if (a.score !== b.score) return a.score - b.score;
            return a.name.localeCompare(b.name);
        });

        aliens.forEach(alien => builder.suggest(alien.name));
        return builder.buildFuture();
    };

    event.register(
        Commands.literal("alienremove")
            .requires(src => src.hasPermission(2))
            .then(Commands.argument("entity", Arguments.PLAYER.create(event))
                .then(Commands.argument("alien", Arguments.RESOURCE_LOCATION.create(event))
                    .suggests(alienSuggestionProvider)
                    .executes(ctx => {

                        let target = Arguments.PLAYER.getResult(ctx, "entity");
                        const alienResource = Arguments.RESOURCE_LOCATION.getResult(ctx, "alien");
                        const alienName = alienResource.toString();
                        const path = alienResource.getPath().toLowerCase();

                        // Lookup ID from global entries
                        let alienNumber = -1;
                        for (let i = 1; i <= 300; i++) {
                            if (!global[`alienevo_alien_${i}`]) continue;

                            let entry = global[`alienevo_alien_${i}`][0].toLowerCase();
                            if (entry === alienName.toLowerCase() || entry === path) {
                                alienNumber = i;
                                break;
                            }
                        }

                        if (alienNumber === -1) {
                            let translateUnknownAlien = Component.translate("command.playlist.alienevo.unknown_alien").getString();
                            ctx.source.sendFailure(Text.of(`${translateUnknownAlien} ${alienName}`));
                            return 0;
                        }

                        // Remove alien from every playlist/slot
                        let removed = 0;
                        for (let p = 1; p <= MAX_PLAYLISTS; p++) {
                            for (let s = 1; s <= MAX_ALIEN_SLOTS; s++) {
                                if (target.persistentData.getInt(`alienevo.alien_${p}_${s}`) === alienNumber) {
                                    removed++;
                                    target.persistentData.putInt(`alienevo.alien_${p}_${s}`, 0);
                                }
                            }
                        }

                        // If alien was active, clear the slot
                        const activeSlot = target.persistentData.getInt(CURRENT_ALIEN_SLOT_KEY) || 1;
                        const activePlaylist = target.persistentData.getInt(CURRENT_PLAYLIST_KEY) || 1;

                        if (target.persistentData.getInt(`alienevo.alien_${activePlaylist}_${activeSlot}`) === alienNumber) {
                            target.persistentData.putInt(`alienevo.alien_${activePlaylist}_${activeSlot}`, 0);
                            palladium.setProperty(target, OMNITRIX_PROPERTY_KEY, 0);
                        }

                        // Update Palladium slot properties
                        for (let slot = 1; slot <= MAX_ALIEN_SLOTS; slot++) {
                            let type = target.persistentData.getInt(`alienevo.alien_${activePlaylist}_${slot}`) || 0;
                            palladium.setProperty(target, `alien_evo_slot_${slot}`, type);
                        }

                        return removed;
                    })
                )
            )
    );
});
