global.sound = (entity, soundId, volume, pitch, shift) => {
    entity.level.runCommandSilent(`playsound ${soundId} player @p ${entity.x} ${entity.y} ${entity.z} ${volume} ${pitch - shift/2 + Math.random()*shift}`);
};

global.applyKnockback = (entity, target, strength) => {
    let dx = target.x - entity.x;
    let dz = target.z - entity.z;
    let distance = Math.sqrt(dx * dx + dz * dz);

    if (distance > 0) {
        let multiplier = strength / distance;
        target.addMotion(
            dx * multiplier,
            0.4,
            dz * multiplier
        );
    }
};

let users = ['minecraft:player'];

users.forEach(key => {
    EntityEvents.death(key, e=> {
        let {entity, source} = e;
        
        // Only activate if player has the alienevo.ultimate tag
        if (!entity.tags.contains('alienevo.ultimate')) {
            return;
        }
        
        let bypasses = ['outOfWorld'];
        let knockbackRadius = 10;
        let knockbackStrength = 3;

        // Ensure the scoreboard objective exists and set the score via command too
        const username = entity.getGameProfile().getName();
        entity.server.runCommandSilent(`scoreboard players set ${username} Alienevo.Ultmate.Cooldown 500`);
        palladium.scoreboard.setScore(entity, "Alienevo.Ultmate.Cooldown", 500);

        let box = AABB.ofSize(entity.position(), knockbackRadius * 2, knockbackRadius * 2, knockbackRadius * 2);
        let nearbyEntities = entity.level.getEntities(entity, box);

        nearbyEntities.forEach(target => {
            if (target !== entity && target.type !== "minecraft:item" &&
                target.type !== "minecraft:item_frame" &&
                target.type !== "minecraft:glow_item_frame" &&
                target.type !== "minecraft:armor_stand") {
                global.applyKnockback(entity, target, knockbackStrength);
            }
        });

        superpowerUtil.addSuperpower(entity, new ResourceLocation(`alienevo:transform_bubble`));
        global.sound(entity, 'item.totem.use', 0.3, 1.8, 0.2);
        global.sound(entity, 'alienevo:prototype_failsafe', 1.0, 1.0, 0.0);
        entity.extinguish()
        entity.setHealth(1.0);
        e.cancel();
    })
});

