// Husk detection script - Command based approach
// Use /testscan command to test the scanning effect

// Function to apply scan effect
function applyScanEffect(player) {
    // Play the scanactive sound using the same method as surgednascanitem.js
    player.level.playSound(
        null, 
        player.x, 
        player.y, 
        player.z, 
        'evo_reds_alienpack:scanactive', 
        player.getSoundSource(), 
        1.0, 
        1.0
    );
    // Add the 'AlienEvo.MasterControlAnim' tag to the player
    player.addTag('AlienEvo.MasterControlAnim');
}

ServerEvents.commandRegistry(event => {
    const { commands: Commands } = event;
    const { literal } = Commands;

    // Test command
    event.register(
        literal('testscan').executes(ctx => {
            const player = ctx.source.player;
            applyScanEffect(player);
            return 1;
        })
    );
    
    // Function command for datapack integration
    event.register(
        literal('function').then(
            literal('reds_things:scan_hotdog').executes(ctx => {
                const player = ctx.source.player;
                applyScanEffect(player);
                return 1;
            })
        )
    );
});

// Use ServerEvents.tick to check for mob deaths with hotdog_powered tag
ServerEvents.tick(event => {
    // Run every 10 ticks (0.5 seconds) for responsive detection
    if (event.server.getTickCount() % 10 !== 0) return;
    
    // Check for players who killed mobs with hotdog_powered tag
    event.server.runCommandSilent(`
        execute as @a at @s if entity @e[type=!player,tag=hotdog_powered,distance=..10] run tag @s add near_hotdog_mob
    `);
    
    // Apply scan effect to players near hotdog powered mobs
    event.server.runCommandSilent(`
        execute as @a[tag=near_hotdog_mob,tag=!scanned_hotdog] run function reds_things:scan_hotdog
    `);
    
    // Mark as scanned to prevent spam
    event.server.runCommandSilent(`
        execute as @a[tag=near_hotdog_mob,tag=!scanned_hotdog] run tag @s add scanned_hotdog
    `);
    
    // Clean up tags
    event.server.runCommandSilent(`tag @a remove near_hotdog_mob`);
});
