ItemEvents.rightClicked('evo_reds_alienpack:screwdriver', event => {
    console.log('Alien meat bits right-clicked by: ' + event.entity.username);
    console.log('Item ID: ' + event.item.id);
    
    // Check if player has the settings_menu palladium ability enabled
    // We need to check if they have any power with the settings_menu ability enabled
    let hasSettingsMenu = false;
    
    try {
        let powerIds = palladium.powers.getPowerIds(event.entity);
        console.log('Player power IDs: ' + JSON.stringify(powerIds));
        
        for (let powerId of powerIds) {
            if (palladium.abilities.isEnabled(event.entity, powerId, 'settings_menu')) {
                hasSettingsMenu = true;
                console.log('Found settings_menu ability in power: ' + powerId);
                break;
            }
        }
    } catch (error) {
        console.log('Error checking Palladium abilities: ' + error.message);
        // If there's an error, assume they don't have the menu (safer default)
        hasSettingsMenu = false;
    }
    
    if (!hasSettingsMenu) {
        event.entity.tell('You need to open the omnitrix settings menu to use this!');
        return;
    }
    
    // Check for existing conditions that would prevent certain events
	let hasRecalPower =
		palladium.superpowers.hasSuperpower(event.entity, 'evo_reds_alienpack:recal_omnitrix') ||
		palladium.superpowers.hasSuperpower(event.entity, 'evo_reds_alienpack_noncustom:recal_omnitrix') ||
        palladium.superpowers.hasSuperpower(event.entity, 'evo_reds_alienpack_ult:ult_omnitrix') ||
        palladium.superpowers.hasSuperpower(event.entity, 'evo_reds_alienpack_noncustom:ult_omnitrix') ||  
        palladium.superpowers.hasSuperpower(event.entity, 'evo_reds_alienpack_bug:prototype_omnitrix') ||
        palladium.superpowers.hasSuperpower(event.entity, 'evo_reds_alienpack_completed:completed_omnitrix');
    let hasMasterControlTag = event.entity.tags.contains('AlienEvo.MasterControl');
    let hasSelfDestructPower = palladium.superpowers.hasSuperpower(event.entity, 'selfdestruct:prototype_omnitrix_sdm');
    let playerLevel = event.entity.experienceLevel;
    let isHighEnoughLevelForRecal = playerLevel >= 50;
    let isHighEnoughLevelForMasterControl = playerLevel >= 30;
    
    console.log('Has recal power: ' + hasRecalPower);
    console.log('Has master control tag: ' + hasMasterControlTag);
    console.log('Has self destruct power: ' + hasSelfDestructPower);
    console.log('Player level: ' + playerLevel + ', high enough for recal: ' + isHighEnoughLevelForRecal + ', high enough for master control: ' + isHighEnoughLevelForMasterControl);
    
    // Generate random number between 0 and 100 for percentage chance
    let randomChance = Math.random() * 100;
    console.log('Random chance rolled: ' + randomChance);
    
    // Define chances (adjust these percentages as needed)
    let recalibrateChance = (hasRecalPower || !isHighEnoughLevelForRecal) ? 0 : 2;    // 2% chance - smallest (0% if already has recal power or under level 50)
    let masterControlChance = (hasMasterControlTag || !isHighEnoughLevelForMasterControl) ? 0 : 3;  // 3% chance - small (0% if already has master control or under level 30)
    let selfDestructChance = hasSelfDestructPower ? 0 : 5;   // 5% chance - bigger (0% if already has self destruct)
    let screwOmnitrixChance = 1;   // 1% chance for screw omnitrix replacement
    
    if (randomChance < screwOmnitrixChance) {
        // Screw Omnitrix replacement - 1% chance
        console.log('Screw Omnitrix replacement triggered!');
        event.entity.runCommandSilent('superpower replace alienevo:prototype_omnitrix evo_reds_alienpack_screw:screwed_omnitrix @s');
        event.entity.runCommandSilent('playsound alienevo:color_module_insert player @s ~ ~ ~');
        
    } else if (randomChance < screwOmnitrixChance + recalibrateChance) {
        // Recalibration - smallest chance
        console.log('Recalibration triggered!');
        event.entity.runCommandSilent('scoreboard players set @s Recaling_Bug.Timer 157');
        event.entity.runCommandSilent('playsound evo_reds_alienpack:first_recal player @s ~ ~ ~ 2');
        event.entity.runCommandSilent('scoreboard players set @s AlienEvo.Tubes 12');
        event.entity.runCommandSilent('tag @s add AlienEvo.MasterControlAnimm');
        event.entity.runCommandSilent('superpower remove selfdestruct:prototype_omnitrix_sdm @s');
        
    } else if (randomChance < screwOmnitrixChance + recalibrateChance + masterControlChance) {
        // Master Control - small chance
        console.log('Master Control unlocked!');
        event.entity.level.playSound(
            null, 
            event.entity.x, 
            event.entity.y, 
            event.entity.z, 
            'evo_reds_alienpack:scanactive', 
            event.entity.getSoundSource(), 
            1.0, 
            1.0
        );
        event.entity.addTag('AlienEvo.MasterControlAnim');
        event.entity.addTag('AlienEvo.MasterControl');
        
    } else if (randomChance < screwOmnitrixChance + recalibrateChance + masterControlChance + selfDestructChance) {
        // Self-Destruct - bigger chance
        console.log('Self-Destruct accidentally triggered!');
        event.entity.runCommandSilent('superpower add selfdestruct:prototype_omnitrix_sdm @s');
        event.entity.runCommandSilent('advancement grant @s only alienevo:code_selfdestruct');
        event.entity.runCommandSilent('playsound evo_reds_alienpack:self_destruct_start player @s ~ ~ ~');
        event.entity.tell('§c<Omnitrix> Self Destruct Sequence Completed and Engaged...');
        
    } else {
        // Nothing happens - most common outcome
        console.log('Screwdriver usage had no effect');
        event.entity.runCommandSilent('playsound alienevo:playlist_swap player @s ~ ~ ~');
        event.entity.tell('§7The screwdriver breaks while jaming it inside.');
    }
    
    if (event.entity.isPlayer()) {
        event.item.shrink(1);
    }
});