global.alienevo_ultimate = {
    31: true,
    35: true,
    29: true,
    11: true,
    2: true
}

StartupEvents.registry('palladium:abilities', event => {
    event.create('evo_reds_alienpack:alien_base_form')
        .icon(palladium.createItemIcon('evo_reds_alienpack:omnitrix_ult'))
        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                let alienCurrentNum = palladium.getProperty(entity, "omnitrix_cycle")
                let alienCurrent = global["alienevo_alien_" + alienCurrentNum]
                let alienCurrentName = alienCurrent.toString().split(':');

                palladium.superpowers.addSuperpower(entity, alienCurrent.toString())
                palladium.superpowers.addSuperpower(entity, "alienevo:transform_bubble")
                palladium.superpowers.removeSuperpower(entity, "evo_reds_alienpack_ult:ult_" + alienCurrentName[1])
                entity.removeTag("alienevo.ultimate")
                
                
                
                entity.level.playSound(
                    null,
                    entity.x,
                    entity.y,
                    entity.z,
                    'alienevo:ult_detransform',
                    entity.getSoundSource(),
                    1.0,
                    1.0
                )

            }
        });
});

StartupEvents.registry('palladium:abilities', event => {
    event.create('evo_reds_alienpack:go_ultimate')
        .icon(palladium.createItemIcon('evo_reds_alienpack:omnitrix_ult'))
        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                let alienCurrentNum = palladium.getProperty(entity, "omnitrix_cycle")
                let alienCurrent = global["alienevo_alien_" + alienCurrentNum]
                let can_go_ultimate = global.alienevo_ultimate[alienCurrentNum]
                let alienCurrentName = alienCurrent.toString().split(':');

                // Check if player has any power from ultimate_evolution
                let hasUltimateEvolutionPower = false
                try {
                    let ultimateEvolutionPowers = palladium.powers.getPowerIdsForNamespace(entity, "ultimate_evolution")
                    if (ultimateEvolutionPowers && ultimateEvolutionPowers.length > 0) {
                        hasUltimateEvolutionPower = true
                    }
                } catch (error) {
                    console.log(`[WARNING] Could not check for ultimate_evolution powers: ${error}`)
                }

                if (can_go_ultimate && !hasUltimateEvolutionPower) {
                    if (can_go_ultimate == true){
                        palladium.superpowers.removeSuperpower(entity, alienCurrent.toString())
                        palladium.superpowers.addSuperpower(entity, "evo_reds_alienpack_ult:ult_" + alienCurrentName[1])
                        palladium.superpowers.addSuperpower(entity, "alienevo:recal_transform_bubble")
                        entity.addTag("alienevo.ultimate")
                        
                        if (!entity.getTags().contains("AlienEvo.MasterControl")) {
                            try {
                                let scoreboard = entity.level.getScoreboard()
                                let objective = scoreboard.getObjective("AlienEvo.Timer")
                                if (objective) {
                                    let currentScore = scoreboard.getOrCreatePlayerScore(entity.getName().getString(), objective).getScore()
                                    if (currentScore <= 5000) {
                                        scoreboard.getOrCreatePlayerScore(entity.getName().getString(), objective).setScore(currentScore + 0)
                                    }
                                }
                            } catch (error) {
                                console.log(`[ERROR] Failed to update AlienEvo.Timer scoreboard: ${error}`)
                            }
                        }
                        
                        entity.level.playSound(
                            null,
                            entity.x,
                            entity.y,
                            entity.z,
                            'alienevo:ult_ultimate',
                            entity.getSoundSource(),
                            1.0,
                            1.0
                        )

                    }
                }
            }
        });
});

StartupEvents.registry('palladium:abilities', event => {
    event.create('evo_reds_alienpack:ultimate_timeout_function')
        .icon(palladium.createItemIcon('evo_reds_alienpack:omnitrix_ult'))
        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                try {
                    let scoreboard = entity.level.getScoreboard()
                    let objective = scoreboard.getObjective("AlienEvo.Timer")
                    if (objective) {
                        let timerScore = scoreboard.getOrCreatePlayerScore(entity.getName().getString(), objective).getScore()
                        let playerHealth = entity.getHealth()
                        if ((timerScore >= 5925 && timerScore <= 6000) || (playerHealth <= 4)) {
                    let alienCurrentNum = palladium.getProperty(entity, "omnitrix_cycle")
                    let alienCurrent = global["alienevo_alien_" + alienCurrentNum]
                    let alienCurrentName = alienCurrent.toString().split(':');

                    palladium.superpowers.addSuperpower(entity, alienCurrent.toString())
                    palladium.superpowers.addSuperpower(entity, "alienevo:transform_bubble")
                    palladium.superpowers.removeSuperpower(entity, "evo_reds_alienpack_ult:ult_" + alienCurrentName[1])
                    entity.removeTag("alienevo.ultimate")
                    
                    entity.level.playSound(
                        null,
                        entity.x,
                        entity.y,
                        entity.z,
                        'alienevo:ult_detransform',
                        entity.getSoundSource(),
                        1.0,
                        1.0
                    )
                        }
                    }
                } catch (error) {
                    console.log(`[ERROR] Failed to get AlienEvo.Timer scoreboard value: ${error}`)
                }
            }
        });
});