PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/ball/form', 200, (builder) => {
        let pelarota_ball_form = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'ball_roll', builder.getPartialTicks());
        builder.get('right_arm')
            .setXRotDegrees(0).setYRotDegrees(0).setZRotDegrees(0)
            .animate('InOutExpo', pelarota_ball_form);
        builder.get('left_arm')
            .setXRotDegrees(0).setYRotDegrees(0).setZRotDegrees(0)
            .animate('InOutExpo', pelarota_ball_form);
        builder.get('chest')
            .setXRotDegrees(0).setYRotDegrees(0).setZRotDegrees(0)
            .animate('InOutExpo', pelarota_ball_form);


        if (pelarota_ball_form > 0.0 && builder.isFirstPerson()) {
        }
    });
});

function clamp(value, min, max) {
    return Math.max(min, Math.min(max, value));
}

let heightDist = 0;
let heightDistO = 0;
let lastY = 0;
let onGroundTimer = 0;
let squashAmount = 0;
let squashAmountO = 0;
let landingVelocity = 0;
let targetSquashAmount = 0;

PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/ball/roll_1', 200, (builder) => {
        let pelarota_ball_roll_1 = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'ball_pivot', builder.getPartialTicks(), 0, 6);
        if (pelarota_ball_roll_1 > 0.0) {
            builder.get('body')
                .setY(4)
                .animate('easeInOutBack', pelarota_ball_roll_1);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/ball/roll_1_scale', 200, (builder) => {
        let pelarota_ball_roll_1_scale = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'ball_pivot', builder.getPartialTicks(), 0, 6);
        if (pelarota_ball_roll_1_scale > 0.0) {
            builder.get('body')
                .scaleY(1 + 0.2)
                .animate('linear', pelarota_ball_roll_1_scale);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/ball/roll_2', 200, (builder) => {
        let pelarota_ball_roll_2 = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'ball_pivot', builder.getPartialTicks(), 6, 12);
        if (pelarota_ball_roll_2 > 0.0) {
            builder.get('body')
                .setY(0)
                .scaleY(1 - 0.2)
                .animate('easeOutBack', pelarota_ball_roll_2);
        }
    });
});
ClientEvents.tick(pelarota_event => {
    if (abilityUtil.hasPower(pelarota_event.player, "evo_reds_alienpack_ult:ult_arburian_pelarota")) {
        // Check if either ball_roll or rumble is enabled
        let pelarota_ballRollEnabled = abilityUtil.isEnabled(pelarota_event.player, "evo_reds_alienpack_ult:ult_arburian_pelarota", "ball_roll");
        let pelarota_rumbleEnabled = abilityUtil.isEnabled(pelarota_event.player, "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble");

        if (pelarota_ballRollEnabled || pelarota_rumbleEnabled) {
            let pelarota_mode = Client.options.getCameraType();
            if (pelarota_mode !== 'third_person_back' && pelarota_mode !== 'third_person_front') {
                pelarota_event.player.persistentData.pelarota_camera_reset = 1;
                Client.options.setCameraType('third_person_back');
            }
        }

        let pelarota_end = pelarota_event.player.persistentData.pelarota_camera_reset;
        // Reset camera only when both abilities are disabled
        if (!pelarota_ballRollEnabled && !pelarota_rumbleEnabled && pelarota_end === 1) {
            pelarota_event.player.persistentData.pelarota_camera_reset = 0;
            Client.options.setCameraType('first_person');
        }
    }
});

PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo_aliens/aburianlimbs', 15, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "arburian_loop")) {
            if (!builder.isFirstPerson()) {
                let halfPi = 1.57079632679;
                builder.get('left_arm').rotateX(builder.getModel().leftArm.xRot * -0.3)
                builder.get('right_arm').rotateX(builder.getModel().rightArm.xRot * -0.3)
                builder.get('right_leg').rotateX(builder.getModel().rightLeg.xRot * -0.4)
                builder.get('left_leg').rotateX(builder.getModel().leftLeg.xRot * -0.4)
            }
            if (builder.isFirstPerson()) {
                builder.get('left_arm').scaleX(0.75).scaleY(0.75).scaleZ(0.75)
                builder.get('right_arm').scaleX(0.75).scaleY(0.75).scaleZ(0.75)
            }
            if (builder.getPlayer().isCrouching() && !builder.isFirstPerson()) {
                builder.get('chest').setXRotDegrees(12).setY(0)
                builder.get('left_leg').setY(10)
                builder.get('right_leg').setY(10)
                builder.get('left_arm').setY(2)
                builder.get('right_arm').setY(2)
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/ball/roll_boost', 250, (builder) => {
        let pelarota_ball_boost = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'boost_still', builder.getPartialTicks(), 0, 40);
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "boost_still")) {
            if (pelarota_ball_boost > 0.0) {
                builder.get('chest')
                    .rotateX(30)
                    .animate('easeInExpo', pelarota_ball_boost);
            } else {
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/ball/roll_slam', 250, (builder) => {
        let pelarota_ball_slam = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'boost_slam', builder.getPartialTicks());
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "boost_slam")) {
            if (pelarota_ball_slam > 0.0) {
                builder.get('chest')
                    .rotateX(30)
                    .animate('easeInOutQuart', pelarota_ball_slam);
            } else {
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/arburianblock', 15, (builder) => {
        let pelarota_block_anim = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'block_abil', builder.getPartialTicks());
        if (pelarota_block_anim > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setYRotDegrees(- 58)
                .setZRotDegrees(15)
                .setX(builder.getModel().rightArm.x - 1)
                .setY(builder.getModel().rightArm.y + 3)
                .animate('InOutCubic', pelarota_block_anim);
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setYRotDegrees(- -58)
                .setZRotDegrees(-15)
                .setX(builder.getModel().leftArm.x + 1)
                .setY(builder.getModel().leftArm.y + 3)
                .animate('InOutCubic', pelarota_block_anim);
        }
        if (pelarota_block_anim > 0.0 && builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-65).setYRotDegrees(15).setZRotDegrees(-90).setX(-10).setY(-4).setZ(-2).animate('InOutCubic', pelarota_block_anim);
            builder.get('left_arm').setXRotDegrees(-65).setYRotDegrees(-15).setZRotDegrees(90).setX(10).setY(-4).setZ(-2).animate('InOutCubic', pelarota_block_anim);
        } else {
        }
    });
});

//body rotate
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_r_1', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_r_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.17 * 20, 0.42 * 20);
            if (pelarota_rumble_body_r_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setXRotDegrees(- -7.5)
                    .animate('InOutSine', pelarota_rumble_body_r_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_r_2', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_r_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.42 * 20, 0.63 * 20);
            if (pelarota_rumble_body_r_2 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setXRotDegrees(- 22.5)
                    .animate('InExpo', pelarota_rumble_body_r_2);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_r_3', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_r_3 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.63 * 20, 0.88 * 20);
            if (pelarota_rumble_body_r_3 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setXRotDegrees(- 90)
                    .animate('OutBack', pelarota_rumble_body_r_3);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_r_4', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_r_4 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.13 * 20, 1.88 * 20);
            if (pelarota_rumble_body_r_4 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setXRotDegrees(0)
                    .animate('InOutSine', pelarota_rumble_body_r_4);
            }
        }
    });
});

// body translate
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_t_1', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_t_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.17 * 20, 0.42 * 20);
            if (pelarota_rumble_body_t_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setY(11)
                    .animate('InSine', pelarota_rumble_body_t_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_t_2', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_t_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.42 * 20, 0.63 * 20);
            if (pelarota_rumble_body_t_2 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setY(16)
                    .animate('OutCubic', pelarota_rumble_body_t_2);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_t_3', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_t_3 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.63 * 20, 0.88 * 20);
            if (pelarota_rumble_body_t_3 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setY(6)
                    .animate('InOutBack', pelarota_rumble_body_t_3);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_body_t_4', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_body_t_4 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.13 * 20, 1.88 * 20);
            if (pelarota_rumble_body_t_4 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .setY(0)
                    .animate('linear', pelarota_rumble_body_t_4);
            }
        }
    });
});

//chest
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_chest_1', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_chest_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0, 0.17 * 20);
            if (pelarota_rumble_chest_1 > 0 && !builder.isFirstPerson()) {
                builder.get('chest')
                    .setXRotDegrees(42.5)
                    .setY(- -5)
                    .setZ(- 9)
                    .animate('InOutSine', pelarota_rumble_chest_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_chest_2', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_chest_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.17 * 20, 0.42 * 20);
            if (pelarota_rumble_chest_2 > 0 && !builder.isFirstPerson()) {
                builder.get('chest')
                    .setXRotDegrees(-12.5)
                    .setY(- +1)
                    .setZ(4)
                    .animate('InOutSine', pelarota_rumble_chest_2);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_chest_3', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_chest_3 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.42 * 20, 0.88 * 20);
            if (pelarota_rumble_chest_3 > 0 && !builder.isFirstPerson()) {
                builder.get('chest')
                    .setXRotDegrees(0)
                    .setZ(- 1)
                    .animate('OutBack', pelarota_rumble_chest_3);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_chest_4', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_chest_4 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.13 * 20, 1.46 * 20);
            if (pelarota_rumble_chest_4 > 0 && !builder.isFirstPerson()) {
                builder.get('chest')
                    .setXRotDegrees(22.5)
                    .setY(- 0.5)
                    .setZ(- 5.5)
                    .animate('OutSine', pelarota_rumble_chest_4);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_chest_5', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_chest_5 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.46 * 20, 1.88 * 20);
            if (pelarota_rumble_chest_5 > 0 && !builder.isFirstPerson()) {
                builder.get('chest')
                    .setXRotDegrees(0)
                    .setY(0)
                    .setZ(0)
                    .animate('InSine', pelarota_rumble_chest_5);
            }
        }
    });
});

//arms translate
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_t_1', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_t_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0, 0.17 * 20);
            if (pelarota_rumble_arms_t_1 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setX(5 + 1)
                    .setY(2 - -7)
                    .setZ(0 - 4)
                    .animate('InOutSine', pelarota_rumble_arms_t_1);
                builder.get('right_arm')
                    .setX(-5 - 1)
                    .setY(2 - -7)
                    .setZ(0 - 4)
                    .animate('InOutSine', pelarota_rumble_arms_t_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_t_2', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_t_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.17 * 20, 0.42 * 20);
            if (pelarota_rumble_arms_t_2 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setX(5 + 1)
                    .setY(2 - 0)
                    .setZ(0 + 2)
                    .animate('InOutQuad', pelarota_rumble_arms_t_2);
                builder.get('right_arm')
                    .setX(-5 - 1)
                    .setY(2 - 0)
                    .setZ(0 + 2)
                    .animate('InOutQuad', pelarota_rumble_arms_t_2);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_t_3', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_t_3 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.42 * 20, 0.71 * 20);
            if (pelarota_rumble_arms_t_3 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setX(5 + 2)
                    .setY(2 - 0)
                    .setZ(0 + 1)
                    .animate('InOutSine', pelarota_rumble_arms_t_3);
                builder.get('right_arm')
                    .setX(-5 - 2)
                    .setY(2 - 0)
                    .setZ(0 + 1)
                    .animate('InOutSine', pelarota_rumble_arms_t_3);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_t_4', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_t_4 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.13 * 20, 1.54 * 20);
            if (pelarota_rumble_arms_t_4 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setX(5 + 0)
                    .setY(2 - 0)
                    .setZ(0 + -3)
                    .animate('InOutQuad', pelarota_rumble_arms_t_4);
                builder.get('right_arm')
                    .setX(-5 - 0)
                    .setY(2 - 0)
                    .setZ(0 + -3)
                    .animate('InOutQuad', pelarota_rumble_arms_t_4);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_t_5', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_t_5 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.54 * 20, 1.88 * 20);
            if (pelarota_rumble_arms_t_5 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setX(5)
                    .setY(2)
                    .setZ(0)
                    .animate('linear', pelarota_rumble_arms_t_5);
                builder.get('right_arm')
                    .setX(-5)
                    .setY(2)
                    .setZ(0)
                    .animate('linear', pelarota_rumble_arms_t_5);
            }
        }
    });
});

//arms rotate
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_r_1', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_r_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0, 0.17 * 20);
            if (pelarota_rumble_arms_r_1 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-20).setYRotDegrees(40).setZRotDegrees(18)
                    .animate('InOutSine', pelarota_rumble_arms_r_1);
                builder.get('right_arm')
                    .setXRotDegrees(-20).setYRotDegrees(-40).setZRotDegrees(-18)
                    .animate('InOutSine', pelarota_rumble_arms_r_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_r_2', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_r_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.17 * 20, 0.50 * 20);
            if (pelarota_rumble_arms_r_2 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-7).setYRotDegrees(-41).setZRotDegrees(-88)
                    .animate('InOutQuad', pelarota_rumble_arms_r_2);
                builder.get('right_arm')
                    .setXRotDegrees(-7).setYRotDegrees(41).setZRotDegrees(88)
                    .animate('InOutQuad', pelarota_rumble_arms_r_2);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_r_3', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_r_3 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.50 * 20, 0.71 * 20);
            if (pelarota_rumble_arms_r_3 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-90).setYRotDegrees(-100).setZRotDegrees(0)
                    .animate('InOutSine', pelarota_rumble_arms_r_3);
                builder.get('right_arm')
                    .setXRotDegrees(-90).setYRotDegrees(100).setZRotDegrees(0)
                    .animate('InOutSine', pelarota_rumble_arms_r_3);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_r_4', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_r_4 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.71 * 20, 0.88 * 20);
            if (pelarota_rumble_arms_r_4 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-90).setYRotDegrees(-65).setZRotDegrees(0)
                    .animate('OutBack', pelarota_rumble_arms_r_4);
                builder.get('right_arm')
                    .setXRotDegrees(-90).setYRotDegrees(65).setZRotDegrees(0)
                    .animate('OutBack', pelarota_rumble_arms_r_4);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_r_5', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_r_5 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.13 * 20, 1.54 * 20);
            if (pelarota_rumble_arms_r_5 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(-52.5).setYRotDegrees(0).setZRotDegrees(0)
                    .animate('InQuad', pelarota_rumble_arms_r_5);
                builder.get('right_arm')
                    .setXRotDegrees(-52.5).setYRotDegrees(0).setZRotDegrees(0)
                    .animate('InQuad', pelarota_rumble_arms_r_5);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_arms_r_6', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_arms_r_6 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.54 * 20, 1.88 * 20);
            if (pelarota_rumble_arms_r_6 > 0 && !builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRotDegrees(0).setYRotDegrees(0).setZRotDegrees(0)
                    .animate('InOutSine', pelarota_rumble_arms_r_6);
                builder.get('right_arm')
                    .setXRotDegrees(0).setYRotDegrees(0).setZRotDegrees(0)
                    .animate('InOutSine', pelarota_rumble_arms_r_6);
            }
        }
    });
});

//legs
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_legs_1', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_legs_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0, 0.17 * 20);
            if (pelarota_rumble_legs_1 > 0 && !builder.isFirstPerson()) {
                builder.get('left_leg')
                    .setXRotDegrees(-7.5).setZRotDegrees(-5)
                    .setX(2 + 0)
                    .setY(12 - 0)
                    .setZ(0 + 5)
                    .animate('InOutSine', pelarota_rumble_legs_1);
                builder.get('right_leg')
                    .setXRotDegrees(-7.5).setZRotDegrees(5)
                    .setX(-2 - 0)
                    .setY(12 - 0)
                    .setZ(0 + 5)
                    .animate('InOutSine', pelarota_rumble_legs_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_legs_2', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_legs_2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.17 * 20, 0.71 * 20);
            if (pelarota_rumble_legs_2 > 0 && !builder.isFirstPerson()) {
                builder.get('left_leg')
                    .setXRotDegrees(40).setZRotDegrees(0)
                    .setX(2 + 0)
                    .setY(12 - 1)
                    .setZ(0 - 1)
                    .animate('OutQuad', pelarota_rumble_legs_2);
                builder.get('right_leg')
                    .setXRotDegrees(40).setZRotDegrees(0)
                    .setX(-2 - 0)
                    .setY(12 - 1)
                    .setZ(0 - 1)
                    .animate('OutQuad', pelarota_rumble_legs_2);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_legs_3', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_legs_3 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 0.71 * 20, 0.88 * 20);
            if (pelarota_rumble_legs_3 > 0 && !builder.isFirstPerson()) {
                builder.get('left_leg')
                    .setXRotDegrees(-17.5)
                    .setX(2 + 0)
                    .setY(12 - 0)
                    .setZ(0 - 1)
                    .animate('InOutBack', pelarota_rumble_legs_3);
                builder.get('right_leg')
                    .setXRotDegrees(-17.5)
                    .setX(-2 - 0)
                    .setY(12 - 0)
                    .setZ(0 - 1)
                    .animate('InOutBack', pelarota_rumble_legs_3);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('pelarota/alienevo/rumble_legs_4', 210, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_arburian_pelarota", "rumble")) {
            let pelarota_rumble_legs_4 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_arburian_pelarota', 'rumble', builder.getPartialTicks(), 1.13 * 20, 1.88 * 20);
            if (pelarota_rumble_legs_4 > 0 && !builder.isFirstPerson()) {
                builder.get('left_leg')
                    .setXRotDegrees(0)
                    .setX(2 + 0)
                    .setY(12 - 0)
                    .setZ(0 - 0)
                    .animate('linear', pelarota_rumble_legs_4);
                builder.get('right_leg')
                    .setXRotDegrees(0)
                    .setX(-2 - 0)
                    .setY(12 - 0)
                    .setZ(0 - 0)
                    .animate('linear', pelarota_rumble_legs_4);
            }
        }
    });
});
