PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vulpimancer/main_anim', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vulpimancer', 'vulpimancer_loop')) {
            if (builder.isFirstPerson()) {
                builder.get('left_arm')
                    .translateX(-5)
                    .translateY(0)
                    .translateZ(0)
                    .setYRotDegrees(-45)
                builder.get('right_arm')
                    .translateX(1)
                    .translateY(-12)
                    .translateZ(-4)
                    .setXRotDegrees(30)
                    .setYRotDegrees(25)
                    .setZRotDegrees(-10)
            } else {
                builder.get('chest').setYRotDegrees(0).setZRotDegrees(0)
                builder.get('right_arm').setYRotDegrees(0).setZRotDegrees(0).rotateX(builder.getModel().rightArm.xRot * -0.20)
                builder.get('left_arm').setYRotDegrees(0).setZRotDegrees(0).rotateX(builder.getModel().leftArm.xRot * -0.20)
                builder.get('right_leg').setYRotDegrees(0).setZRotDegrees(0).rotateX(builder.getModel().rightLeg.xRot * -0.20)
                builder.get('left_leg').setYRotDegrees(0).setZRotDegrees(0).rotateX(builder.getModel().leftLeg.xRot * -0.20)
                if (builder.getPlayer().isCrouching()) {
                    builder.get('head')
                        .translateY(4)
                    builder.get('chest')
                        .translateY(4)
                        .setXRotDegrees(15)
                    builder.get('left_leg')
                        .translateY(11)
                        .translateZ(2)
                    builder.get('right_leg')
                        .translateY(11)
                        .translateZ(2)
                    builder.get('right_arm')
                        .rotateXDegrees(-15)
                        .translateY(1)
                        .translateZ(2)
                    builder.get('left_arm')
                        .rotateXDegrees(-15)
                        .translateY(1)
                        .translateZ(2)
                    builder.get('body')
                        .translateY(0)
                }
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vulpimancer/sprint', 15, (builder) => {
        const sprintAnimation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vulpimancer', 'sprint_function', builder.getPartialTicks());
        if (sprintAnimation > 0.0 && !builder.isFirstPerson()) {
            builder.get('left_arm').setXRot(builder.getModel().rightLeg.xRot).animate('easeOutBack', sprintAnimation);
            builder.get('right_arm').setXRot(builder.getModel().rightLeg.xRot).animate('easeOutBack', sprintAnimation);
            builder.get('right_leg').setXRot(builder.getModel().leftLeg.xRot + 0.6).animate('easeOutBack', sprintAnimation);
            builder.get('left_leg').setXRot(builder.getModel().leftLeg.xRot + 0.6).animate('easeOutBack', sprintAnimation);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vulpimancer/swim', 15, (builder) => {
        const swimAnimation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vulpimancer', 'swim_function', builder.getPartialTicks());
        if (swimAnimation > 0.0) {
            builder.get('body').setXRotDegrees(60).animate('InOutCubic', swimAnimation);
            builder.get('left_arm').setXRot(builder.getModel().rightLeg.xRot).rotateX(builder.getModel().leftArm.xRot * 2).animate('InOutCubic', swimAnimation);
            builder.get('right_arm').setXRot(builder.getModel().rightLeg.xRot).rotateX(builder.getModel().leftArm.xRot * 2).animate('InOutCubic', swimAnimation);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vulpimancer/wall_climb', 15, (builder) => {
        const climbAnimation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vulpimancer', 'surface_climbing_anim', builder.getPartialTicks());
        if (climbAnimation > 0.0) {

            builder.get('head')
                .setXRotDegrees(0)
                .animate('InOutCubic', climbAnimation);
            builder.get('body').setXRotDegrees(90).translateZ(-10).animate('InOutCubic', climbAnimation);


        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vulpimancer/legs', 15, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "evo_reds_alienpack_ult:ult_vulpimancer", "vulpimancer_loop")) {
            if (!builder.isFirstPerson()) {
                builder.get('right_leg').rotateX(builder.getModel().rightLeg.xRot * -0.4)
                builder.get('left_leg').rotateX(builder.getModel().leftLeg.xRot * -0.4)

            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vulpimancer/wall_climb_1', 2, (builder) => {
        const wallClimbProgress1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vulpimancer', 'surface_climb_1', builder.getPartialTicks());
        if (wallClimbProgress1 > 0.0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(15)
                .animate('easeInOutSine', wallClimbProgress1);
            builder.get('left_arm')
                .setXRotDegrees(-25)
                .animate('easeInOutSine', wallClimbProgress1);
            builder.get('right_leg')
                .setXRotDegrees(-25)
                .translateZ(-2)
                .animate('easeInOutSine', wallClimbProgress1);
            builder.get('left_leg')
                .setXRotDegrees(25)
                .translateZ(2)
                .animate('easeInOutSine', wallClimbProgress1);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('evo_reds_alienpack_ult/vulpimancer/wall_climb_2', 2, (builder) => {
        const wallClimbProgress2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'evo_reds_alienpack_ult:ult_vulpimancer', 'surface_climb_2', builder.getPartialTicks());
        if (wallClimbProgress2 > 0.0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-25)
                .animate('easeInOutSine', wallClimbProgress2);
            builder.get('left_arm')
                .setXRotDegrees(15)
                .animate('easeInOutSine', wallClimbProgress2);
            builder.get('right_leg')
                .setXRotDegrees(25)
                .translateZ(2)
                .animate('easeInOutSine', wallClimbProgress2);
            builder.get('left_leg')
                .setXRotDegrees(-25)
                .translateZ(-2)
                .animate('easeInOutSine', wallClimbProgress2);
        }
    });
});
