ItemEvents.rightClicked('evo_reds_alienpack:surge_fragment', event => {
    console.log('Surge fragment right-clicked by: ' + event.entity.username);
    console.log('Item ID: ' + event.item.id);
    
    // Check if player has the settings_menu palladium ability enabled
    // We need to check if they have any power with the settings_menu ability enabled
    let hasSettingsMenu = false;
    let powerIds = palladium.powers.getPowerIds(event.entity);
    
    for (let powerId of powerIds) {
        if (palladium.abilities.isEnabled(event.entity, powerId, 'settings_menu')) {
            hasSettingsMenu = true;
            break;
        }
    }
    
    if (!hasSettingsMenu) {
        event.entity.tell('You need to open the omnitrix settings menu to use this!');
        return;
    }
    
    event.server.runCommandSilent(`playsound evo_reds_alienpack:scanactive @a ${event.entity.x} ${event.entity.y} ${event.entity.z} 1.0 1.0`);
    event.entity.addTag('AlienEvo.MasterControlAnim');
    if (event.entity.isPlayer()) {
        event.server.runCommandSilent(`alienautoadd ${event.entity.username} reds_aliens:surge`);
        // Consume the item after successful use
        event.item.shrink(1);
    }
});