let $ClipContext = Java.loadClass('net.minecraft.world.level.ClipContext');
let $Block = Java.loadClass('net.minecraft.world.level.ClipContext$Block');
let $Fluid = Java.loadClass('net.minecraft.world.level.ClipContext$Fluid');
let $Vec3 = Java.loadClass('net.minecraft.world.phys.Vec3');

function getGrappleTarget(entity, maxDistance) {
    maxDistance = maxDistance || 60;
    let level = entity.getLevel();
    let eyePos = entity.getEyePosition(1);
    let lookVec = entity.getLookAngle().scale(maxDistance);
    let endPos = eyePos.add(lookVec.x(), lookVec.y(), lookVec.z());
    let clip = new $ClipContext(eyePos, endPos, $Block.COLLIDER, $Fluid.NONE, entity);
    let hit = level.clip(clip);
    if (hit.getType().toString() === 'MISS') return null;
    return hit.getLocation();
}

function clamp(value, min, max) {
    return Math.max(min, Math.min(max, value));
}

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('altbreak:grapple')
        .icon(palladium.createItemIcon('minecraft:lead'))
        .addProperty('max_distance', 'integer', 60, '')
        .addProperty('pull_strength', 'float', 2.0, '')
        .addProperty('particles', 'boolean', true, '')
        .addProperty('grapple_speed', 'float', 1.5, '')
        .firstTick((entity, entry, holder, enabled) => {
            if (!enabled) return;
            let maxDistance = entry.getPropertyByName('max_distance') || 60;
            let pullStrength = entry.getPropertyByName('pull_strength') || 2.0;
            let showParticles = entry.getPropertyByName('particles');
            let grappleSpeed = entry.getPropertyByName('grapple_speed') || 1.5;
            let targetPos = getGrappleTarget(entity, maxDistance);
            if (!targetPos) return;
            let dx = targetPos.x() - entity.getX();
            let dy = targetPos.y() - (entity.getY() + entity.getEyeHeight());
            let dz = targetPos.z() - entity.getZ();
            let dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            let travelTime = Math.ceil(dist / grappleSpeed);
            entity.persistentData['grappleTarget'] = {
                x: targetPos.x(),
                y: targetPos.y(),
                z: targetPos.z(),
                strength: pullStrength,
                particles: showParticles,
                wait: travelTime,
                totalWait: travelTime
            };
        })
        .tick((entity) => {
            if (!entity.persistentData['grappleTarget']) return;
            let t = entity.persistentData['grappleTarget'];
            let px = entity.getX();
            let py = entity.getY() + entity.getEyeHeight();
            let pz = entity.getZ();

            if (t.wait > 0) {
                t.wait--;
                return;
            }

            let dx = t.x - px;
            let dy = t.y - py;
            let dz = t.z - pz;
            let dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (dist < 1) {
                entity.persistentData.remove('grappleTarget');
                return;
            }
            let motion = new $Vec3(
                clamp(dx / dist * t.strength, -3, 3),
                clamp(dy / dist * t.strength, -3, 3),
                clamp(dz / dist * t.strength, -3, 3)
            );
            entity.setDeltaMovement(motion);
            entity.hurtMarked = true;
            entity.fallDistance = 0;
        });

    event.create('altbreak:cut_grapple')
        .icon(palladium.createItemIcon('minecraft:barrier'))
        .firstTick((entity) => {
            if (entity.persistentData['grappleTarget']) {
                entity.persistentData.remove('grappleTarget');
            }
        });

});