StartupEvents.registry('item', event => {


  event.create('alienevo:recal_omnitrix')
    .displayName("Recalibrated Omnitrix")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/recal_omnitrix')
    .texture('layer1', 'alienevo:item/recal_omnitrix_glow_1')
    .texture('layer2', 'alienevo:item/recal_omnitrix_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0x8ed721;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor3';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('alienevo:recal_core')
    .displayName("Recalibrated Omnitrix Core")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/recal_core')
    .texture('layer1', 'alienevo:item/recal_core_glow_1')
    .texture('layer2', 'alienevo:item/recal_core_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0x8ed721;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor3';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('alienevo:reboottwo_core')
    .displayName("Upgraded Omnitrix Core")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/reboottwo_core')
    .texture('layer1', 'alienevo:item/reboottwo_core_glow_1')
    .texture('layer2', 'alienevo:item/reboottwo_core_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0x8ed721;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor3';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('alienevo:completed_omnitrix')
    .displayName("Completed Omnitrix")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/completed_omnitrix')
    .texture('layer1', 'alienevo:item/completed_omnitrix_glow_1')
    .texture('layer2', 'alienevo:item/completed_omnitrix_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0xa7f72e;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor2';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('alienevo:completed_core')
    .displayName("Completed Omnitrix Core")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/comp_core')
    .texture('layer1', 'alienevo:item/comp_core_glow_1')
    .texture('layer2', 'alienevo:item/comp_core_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0x8ed721;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor3';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('alienevo:ult_omnitrix')
    .displayName("Ultimatrix")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/ult_omnitrix')
    .texture('layer1', 'alienevo:item/ult_omnitrix_glow_1')
    .texture('layer2', 'alienevo:item/ult_omnitrix_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0xa7f72e;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor2';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('alienevo:ult_core')
    .displayName("Ultimatrix Core")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/ult_core')
    .texture('layer1', 'alienevo:item/ult_core_glow_1')
    .texture('layer2', 'alienevo:item/ult_core_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0x8ed721;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor3';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('evo_reds_alienpack_bug:prototype_omnitrix')
    .displayName("Bugged Recalibrated Omnitrix")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/buggy_omnitrix')
    .texture('layer1', 'alienevo:item/buggy_omnitrix_glow_1')
    .texture('layer2', 'alienevo:item/buggy_omnitrix_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0xa7f72e;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor2';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

  event.create('alienevo:reboottwo_omnitrix')
    .displayName("Upgraded Omnitrix")
    .maxStackSize(1)
    .rarity('epic')
    .fireResistant()
    .texture('layer0', 'alienevo:item/reboottwo_omnitrix')
    .texture('layer1', 'alienevo:item/reboottwo_omnitrix_glow_1')
    .texture('layer2', 'alienevo:item/reboottwo_omnitrix_glow_2')
    .color((stack, i) => {
      if (i !== 1 && i !== 2) return -1;

      let fallback = i === 1 ? 0xb3ff40 : 0x77b913;
      if (!stack.hasNBT()) return fallback;

      let key = i === 1 ? 'storedGlowColor1' : 'storedGlowColor2';
      let string = (stack.nbt.getString(key) + '').trim();
      let v = parseInt(string, 16);

      return string.length === 6 && !Number.isNaN(v) ? v : fallback;
    });

});

StartupEvents.modifyCreativeTab('kubejs:tab', event => {
  event.remove('alienevo:recal_omnitrix');
  event.remove('alienevo:recal_core');
  event.remove('alienevo:completed_omnitrix');
  event.remove('alienevo:completed_core');
  event.remove('alienevo:ult_omnitrix');
  event.remove('alienevo:ult_core');
  event.remove('alienevo:reboottwo_omnitrix');
  event.remove('alienevo:reboottwo_core');
  event.remove('evo_reds_alienpack_bug:prototype_omnitrix');

});

// /give @s alienevo:prototype_omnitrix{storedGlowColor1:"4b73d4",storedGlowColor3:"14499a"}

// /give @s alienevo:prototype_core_tinted{storedGlowColor1:"4b73d4",storedGlowColor2:"345ec3",storedGlowColor3:"14499a"}






