function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

StartupEvents.registry('palladium:abilities', function (event) {
    const OMNITRIX_PROPERTY_KEY = 'omnitrix_cycle';
    const CURRENT_PLAYLIST_KEY = 'current_playlist';
    const CURRENT_ALIEN_SLOT_KEY = 'current_alien_slot';
    const DEFAULT_PLAYLIST = 1;
    const DEFAULT_SLOT = 1;
    const MAX_PLAYLISTS = 10;
    const MAX_SLOTS = 10;

    event.create('evo_reds_alienpack:omnitrix_random_transform')
        .icon(palladium.createItemIcon('minecraft:blaze_rod'))
        .addProperty("property", "string", OMNITRIX_PROPERTY_KEY, "Internal property key for the Omnitrix cycle")
        .addProperty("transform_sound", "string", "prototype", "The primary sound set to use during transformation (e.g., 'prototype')")
        .addProperty("use_multiple_sounds", "boolean", false, "Whether to randomize between multiple transformation sounds")
        .addProperty("alt_sound_1", "string", "omnitrix", "First alternative transformation sound")
        .addProperty("alt_sound_2", "string", "alien_force", "Second alternative transformation sound")
        .addProperty("use_randomizer", "boolean", true, "Whether to use the randomizer functionality")
        .addProperty("use_rarity_unlock", "boolean", true, "Whether to use rarity-based unlocking system")
        .lastTick(function (entity, abilityEntry, abilityHolder, isEnabled) {
            if (!isEnabled || !entity) return;
            transformRandomOnly(entity, abilityEntry);
        });

    // -----------------------------
    // RANDOM-ONLY TRANSFORMATION
    // -----------------------------
    function transformRandomOnly(entity, abilityEntry) {
        let omnitrixPropertyKey = abilityEntry.getPropertyByName('property');

        // 0.2% chance to unlock new alien
        var useRarity = abilityEntry.getPropertyByName("use_rarity_unlock");
        if (useRarity) {
            if (getRandomInt(1, 500) === 1) {
                var newAlien = tryUnlockRandomAlien(entity);
                if (newAlien) {
                    var slot = findNearestEmptySlot(entity);
                    if (slot) {
                        entity.persistentData["alienevo.alien_" + slot.playlist + "_" + slot.slot] = newAlien;
                    }
                }
            }
        }

        var unlockedSlots = [];

        // collect all slots for unlocked aliens
        for (var playlist = 1; playlist <= MAX_PLAYLISTS; playlist++) {
            for (var slot = 1; slot <= MAX_SLOTS; slot++) {
                var id = entity.persistentData["alienevo.alien_" + playlist + "_" + slot];
                if (id && id > 0) {
                    unlockedSlots.push({ id: id, playlist: playlist, slot: slot });
                }
            }
        }

        if (unlockedSlots.length === 0) return;

        // choose a random alien along with its playlist and slot
        var chosen = unlockedSlots[getRandomInt(0, unlockedSlots.length - 1)];

        // update persistentData so detransform knows where it came from
        entity.persistentData[CURRENT_PLAYLIST_KEY] = chosen.playlist;
        entity.persistentData[CURRENT_ALIEN_SLOT_KEY] = chosen.slot;

        // set the omnitrix property
        palladium.setProperty(entity, omnitrixPropertyKey, chosen.id);

        // apply the transformation
        var sound = getTransformSound(abilityEntry, entity);
        transformToAlien(entity, chosen.id, sound);
    }

    // -----------------------------
    // RANDOM ALIEN UNLOCK SYSTEM
    // -----------------------------
    function tryUnlockRandomAlien(entity) {
        var available = getAvailableUnlocks(entity);
        if (available.length === 0) return null;
        return available[getRandomInt(0, available.length - 1)].id;
    }

    function getAvailableUnlocks(entity) {
        var unlocked = getUnlockedAliens(entity);
        var out = [];
        if (!global.alienevo_randomization) return out;

        for (var key in global.alienevo_randomization) {
            var enabled = !!global.alienevo_randomization[key];
            var id = parseInt(key);

            if (!enabled || id === 0) continue;
            if (unlocked.indexOf(id) !== -1) continue;

            out.push({ id: id });
        }

        return out;
    }

    function getUnlockedAliens(entity) {
        var arr = [];
        for (var playlist = 1; playlist <= MAX_PLAYLISTS; playlist++) {
            for (var slot = 1; slot <= MAX_SLOTS; slot++) {
                var id = entity.persistentData["alienevo.alien_" + playlist + "_" + slot];
                if (id && id > 0 && arr.indexOf(id) === -1) arr.push(id);
            }
        }
        return arr;
    }

    function findNearestEmptySlot(entity) {
        for (var playlist = 1; playlist <= MAX_PLAYLISTS; playlist++) {
            for (var slot = 1; slot <= MAX_SLOTS; slot++) {
                var id = entity.persistentData["alienevo.alien_" + playlist + "_" + slot];
                if (!id || id === 0) {
                    return { playlist: playlist, slot: slot };
                }
            }
        }
        return null;
    }

    // -----------------------------
    // SOUND PICKER
    // -----------------------------
    function getTransformSound(abilityEntry, entity) {
        var useMultiple = abilityEntry.getPropertyByName("use_multiple_sounds");
        var main = abilityEntry.getPropertyByName("transform_sound");
        var a1 = abilityEntry.getPropertyByName("alt_sound_1");
        var a2 = abilityEntry.getPropertyByName("alt_sound_2");

        if (!useMultiple) return main;

        var roll = getRandomInt(1, 3);
        if (roll === 1) return main;
        if (roll === 2) return a1;
        return a2;
    }

    // -----------------------------
    // APPLY TRANSFORMATION
    // -----------------------------
    function transformToAlien(entity, alienNumber, soundName) {
        var alienInfo = global["alienevo_alien_" + alienNumber];
        if (!alienInfo) return;

        var fullName = alienInfo[0];
        var namespace = "alienevo_aliens";
        var path = fullName;

        if (fullName.indexOf(":") !== -1) {
            var split = fullName.split(":");
            namespace = split[0];
            path = split[1];
        }

        // Remove current watch power
        var watchNS = palladium.getProperty(entity, "watch_namespace");
        var watchName = palladium.getProperty(entity, "watch");
        var watchPower = new ResourceLocation(watchNS, watchName + "_omnitrix");
        palladium.superpowers.removeSuperpower(entity, watchPower);

        // Apply alien power
        palladium.superpowers.addSuperpower(entity, new ResourceLocation(namespace, path));

        // Store current alien in persistentData for detransform
        entity.persistentData['alienevo.current_namespace'] = namespace;
        entity.persistentData['alienevo.current_path'] = path;

        // Add bubble effect
        palladium.superpowers.addSuperpower(entity, new ResourceLocation("alienevo", "transform_bubble"));

        // Play transform sound
        entity.level.playSound(
            null,
            entity.x, entity.y, entity.z,
            "alienevo:" + soundName + "_transform",
            entity.getSoundSource(),
            1.0,
            1.0
        );
    }
});

StartupEvents.registry('palladium:abilities', (event) => {
    const OMNITRIX_PROPERTY_KEY = 'omnitrix_cycle';
    const CURRENT_PLAYLIST_KEY = 'current_playlist';
    const CURRENT_ALIEN_SLOT_KEY = 'current_alien_slot';
    const MAX_PLAYLISTS = 10;
    const MAX_SLOTS = 10;

    event.create('evo_reds_a:omnitrix_sync_current_alien')
        .icon(palladium.createItemIcon('minecraft:blaze_rod'))
        .addProperty("property", "string", OMNITRIX_PROPERTY_KEY, "The Omnitrix property key to sync")
        .lastTick((entity, abilityEntry, abilityHolder, isEnabled) => {
            if (!isEnabled || !entity) return;

            const omnitrixPropertyKey = abilityEntry.getPropertyByName('property');
            const currentAlienId = palladium.getProperty(entity, omnitrixPropertyKey);
            if (!currentAlienId || currentAlienId <= 0) return;

            // Search all playlists/slots for this alien
            for (let playlist = 1; playlist <= MAX_PLAYLISTS; playlist++) {
                for (let slot = 1; slot <= MAX_SLOTS; slot++) {
                    const id = entity.persistentData[`alienevo.alien_${playlist}_${slot}`];
                    if (id === currentAlienId) {
                        entity.persistentData[CURRENT_PLAYLIST_KEY] = playlist;
                        entity.persistentData[CURRENT_ALIEN_SLOT_KEY] = slot;
                        return; // Found it, stop scanning
                    }
                }
            }
        });
});



