// KubeJS 1.20.1 + Palladium
// Ability: alienevo:give_random_aliens
// Only gives random aliens if the player has NONE already.

// Constants
var MAX_PLAYLISTS = 10;
var SLOTS_PER_PLAYLIST = 10;
var CURRENT_PLAYLIST_KEY = 'current_playlist';
var CURRENT_ALIEN_SLOT_KEY = 'current_alien_slot';

// ----- Utility: sync slot properties so Palladium sees the aliens -----
function updateAllSlotProperties(entity, playlist) {
  try {
    for (var slot = 1; slot <= SLOTS_PER_PLAYLIST; slot++) {
      var key = 'alienevo.alien_' + playlist + '_' + slot;
      var stored = entity.persistentData.getInt(key) || 0;
      palladium.setProperty(entity, 'alien_evo_slot_' + slot, stored);
    }
  } catch (err) {
    console.log('[alienevo] Failed updateAllSlotProperties: ' + err);
  }
}

// ----- Build list of allowed alien IDs -----
function buildAlienPool() {
  return [1,2,3,4,5,6,7,8,10,11,31,34,30,29,49,48];
}

// ----- NEW: Check if player already owns any aliens -----
function playerHasAnyAliens(entity) {
  for (var p = 1; p <= MAX_PLAYLISTS; p++) {
    for (var s = 1; s <= SLOTS_PER_PLAYLIST; s++) {
      var key = 'alienevo.alien_' + p + '_' + s;
      if ((entity.persistentData.getInt(key) || 0) !== 0) {
        return true; // STOP – player already has aliens
      }
    }
  }
  return false; // SAFE – player has none
}

// ----- Main: give 10 random aliens (ONLY if none owned) -----
function giveTenRandomAliens(entity) {

  // ---------------------------
  // IMPORTANT RULE YOU ASKED FOR:
  // Do NOT randomize if the player has aliens already.
  // ---------------------------
  if (playerHasAnyAliens(entity)) {
    console.log('[alienevo] Player already has aliens — skipping randomization.');
    return;
  }

  var pool = buildAlienPool().slice();
  var chosen = [];
  var count = Math.min(10, pool.length);

  // Pick 10 unique random IDs
  for (var i = 0; i < count; i++) {
    var j = Math.floor(Math.random() * pool.length);
    chosen.push(pool.splice(j, 1)[0]);
  }

  var playlist = 1;

  // Fill playlist 1 slots
  for (var slot = 1; slot <= count; slot++) {
    var key = 'alienevo.alien_' + playlist + '_' + slot;
    entity.persistentData.putInt(key, chosen[slot - 1]);
  }

  // Empty leftover slots
  for (var slot2 = count + 1; slot2 <= SLOTS_PER_PLAYLIST; slot2++) {
    entity.persistentData.putInt('alienevo.alien_' + playlist + '_' + slot2, 0);
  }

  // Clear other playlists
  for (var p = 2; p <= MAX_PLAYLISTS; p++) {
    for (var s = 1; s <= SLOTS_PER_PLAYLIST; s++) {
      entity.persistentData.putInt('alienevo.alien_' + p + '_' + s, 0);
    }
  }

  // Update active playlist + active slot
  entity.persistentData.putInt(CURRENT_PLAYLIST_KEY, playlist);
  entity.persistentData.putInt(CURRENT_ALIEN_SLOT_KEY, 1);

  updateAllSlotProperties(entity, playlist);

  console.log('[alienevo] Gave player new aliens: ' + chosen.join(', '));
}

// ----- Register Palladium ability -----
StartupEvents.registry('palladium:abilities', event => {
  event.create('evo_reds_alienpack:give_random_aliens')
    .icon(palladium.createItemIcon('alienevo:prototype_omnitrix'))
    .addProperty('property', 'string', 'alienevo.random_give', '')
    .tick((entity, entry, holder, enabled) => {
      if (!enabled) return;
      try {
        giveTenRandomAliens(entity);

        // Disable automatically after use
        if (entry && entry.setEnabled) {
          entry.setEnabled(false);
        }

      } catch (err) {
        console.log('[alienevo] Error in ability: ' + err);
      }
    });
});
