// Register custom animations
PalladiumEvents.registerAnimations((event) => {
    event.register('afomni/wings', 10, (builder) => {

        // Gets the current animation timer progress from the ability, returned value is a number from 0.0 to 1.0
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'alienevo_aliens:aerophibian', 'flight_anim', builder.getPartialTicks());

        // only apply animation if progress is above 0!
        if (progress > 0.0) {
            const halfPi = 1.57079632679;

            // if first person
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(75).multiplier(progress)
                    .setY(10)
                    .setZ(5)
            } else {
                // third person animations
                builder.get('right_arm')
                    .setXRotDegrees(-85)
                    .setYRotDegrees(60)
                    .animate('EaseInOutCubic', progress);
                    
                    builder.get('left_arm')
                    .setXRotDegrees(-85)
                    .setYRotDegrees(-60)
                    .animate('EaseInOutCubic', progress);

                    builder.get('right_leg')
                    .setXRotDegrees(25)

      
                    .animate('EaseInOutCubic', progress);

                     builder.get('left_leg')
                    .setXRotDegrees(25)
                    


                     .animate('EaseInOutCubic', progress);

            }
        }

    });
});