
function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}


function checkTransformationTimeout(player) {
    if (player.tags.contains('AlienEvo.Transformation')) {
        if (player.tags.contains('AlienEvo.MasterControl')) {
            return;
        }
        
        const ultimatrixScore = palladium.scoreboard.getScore(player, 'Red.Ultimatrix');
        
        if (ultimatrixScore === 1) {
            const hasSetTimer = player.persistentData.getBoolean('ulti_random_timer_set');
            
            if (!hasSetTimer) {
                const randomTimer = getRandomInt(500, 5000);
                
                palladium.scoreboard.setScore(player, 'AlienEvo.Timer', randomTimer);
                
                player.persistentData.putBoolean('ulti_random_timer_set', true);
            }
        }
    } else {
        player.persistentData.remove('ulti_random_timer_set');
    }
}


PlayerEvents.tick(event => {
    const player = event.player;
    

    if (event.player.age % 20 === 0) {
        checkTransformationTimeout(player);
    }
});
