// Global variable to store the giveafaliens setting
global.recalGiveAFAliens = global.recalGiveAFAliens || true;

// Register the custom command
ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event;

    event.register(
        Commands.literal('recalgamerule')
            .then(
                Commands.literal('giveafaliens')
                    .then(
                        Commands.argument('state', Arguments.BOOLEAN.create(event))
                            .executes(ctx => {
                                const state = Arguments.BOOLEAN.getResult(ctx, 'state');
                                global.recalGiveAFAliens = state;
                                
                                if (state) {
                                    // Give all players the tag and remove disable tag
                                    Utils.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
                                    Utils.server.runCommandSilent('tag @a remove Recal.DisableAutoTag');
                                    ctx.source.sendSuccess(Text.of('§a[Recal] GiveAFAliens set to true. All players now gain AF aliens on recal.'), false);
                                } else {
                                    // Remove the tag from all players and add disable tag
                                    Utils.server.runCommandSilent('tag @a remove Recal.GiveAFAliens');
                                    Utils.server.runCommandSilent('tag @a add Recal.DisableAutoTag');
                                    ctx.source.sendSuccess(Text.of('§c[Recal] GiveAFAliens set to false. All players dont gain AF aliens on recal.'), false);
                                }
                                
                                return 1;
                            })
                    )
            )
            .executes(ctx => {
                ctx.source.sendSuccess(Text.of('§e[Recal] Current GiveAFAliens setting: ' + (global.recalGiveAFAliens ? 'true' : 'false')), false);
                return 1;
            })
    );
});

// World start event - give all players the tag if the setting is true
ServerEvents.loaded(event => {
    console.log('[Recal] World loaded event triggered');
    if (global.recalGiveAFAliens) {
        // Try multiple approaches to ensure the tag gets applied
        event.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
        Utils.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
        console.log('[Recal] World loaded - GiveAFAliens is enabled, all players have been given the Recal.GiveAFAliens tag');
    }
});

// Alternative server start event
ServerEvents.tick(event => {
    // Only run once when server starts
    if (!global.recalInitialized) {
        global.recalInitialized = true;
        console.log('[Recal] Server tick initialization');
        if (global.recalGiveAFAliens) {
            event.server.runCommandSilent('tag @a add Recal.GiveAFAliens');
            console.log('[Recal] Server tick - GiveAFAliens is enabled, all players have been given the Recal.GiveAFAliens tag');
        }
    }
});

// Player join event - give new players the tag if the setting is true
PlayerEvents.loggedIn(event => {
    console.log('[Recal] Player ' + event.player.name + ' joined');
    if (global.recalGiveAFAliens) {
        event.player.runCommandSilent('tag @s add Recal.GiveAFAliens');
        event.server.runCommandSilent('tag ' + event.player.name + ' add Recal.GiveAFAliens');
        console.log('[Recal] Player ' + event.player.name + ' joined - GiveAFAliens is enabled, player has been given the Recal.GiveAFAliens tag');
    }
});
