PalladiumEvents.registerAnimations((event) => {
    event.register('earth/slam', 200, (builder) => {
        let earth_slam = animationUtil.getAnimationTimerAbilityValue(
            builder.getPlayer(), 'afomni:vaxasaurian', 'earth_slam', builder.getPartialTicks());

        builder.get('body')
            .moveY(-8)
            .animate('InOutBack', earth_slam);

        builder.get('head')
            .setX(0)
            .setY(2.25)
            .setZ(-3)
            .rotateXDegrees(10)
            .animate('InOutBack', earth_slam);

        builder.get('chest')
            .setX(0)
            .setY(2)
            .setZ(-3)
            .setXRotDegrees(20)
            .animate('InOutBack', earth_slam);

        builder.get('right_arm')
            .setX(-5)
            .setY(5)
            .setZ(-3)
            .setXRotDegrees(-29)
            .setYRotDegrees(-23)
            .setZRotDegrees(19)
            .animate('InOutBack', earth_slam);

        builder.get('left_arm')
            .setX(5)
            .setY(4)
            .setZ(-2)
            .animate('InOutBack', earth_slam);

        builder.get('right_leg')
            .setX(-1.9)
            .setY(12)
            .setZ(-4)
            .setXRotDegrees(75)
            .animate('InOutBack', earth_slam);

        builder.get('left_leg')
            .setX(1.9)
            .setY(7)
            .setZ(-3)
            .setXRotDegrees(10)
            .animate('InOutBack', earth_slam);
            
    });
});
